"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "insurerPaymentRoute", {
    enumerable: true,
    get: function() {
        return insurerPaymentRoute;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const insurerPaymentRoute = _express.default.Router();
insurerPaymentRoute.get('/:invoiceId/insurerPayments', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('list', 'InvoicePayment');
    const invoiceId = req.params.invoiceId;
    const insurerPayments = await req.models.InvoiceInsurerPayment.findAll({
        include: [
            {
                model: req.models.InvoicePayment,
                as: 'detail',
                where: {
                    invoiceId
                }
            },
            {
                model: req.models.ReferenceData,
                as: 'insurer'
            }
        ]
    }).then((payments)=>payments.map((payment)=>({
                id: payment.invoicePaymentId,
                date: payment.detail.date,
                amount: payment.detail.amount,
                receiptNumber: payment.detail.receiptNumber,
                insurerName: payment.insurer.name,
                status: payment.status
            })));
    res.json({
        count: insurerPayments.length,
        data: insurerPayments
    });
}));

//# sourceMappingURL=insurerPayment.js.map