"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "patientContact", {
    enumerable: true,
    get: function() {
        return patientContact;
    }
});
const _crudHelpers = require("@tamanu/shared/utils/crudHelpers");
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const patientContact = _express.default.Router();
patientContact.get('/:id/reminderContacts', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('read', 'Patient');
    return (0, _crudHelpers.simpleGetList)('PatientContact', 'patientId', {
        skipPermissionCheck: true
    })(req, res);
}));
patientContact.post('/reminderContact', (0, _expressasynchandler.default)(async (req, res)=>{
    req.checkPermission('write', 'Patient');
    const { models, websocketClientService } = req;
    const patientContact = await models.PatientContact.create(req.body);
    websocketClientService?.emit(_constants.WS_EVENTS.PATIENT_CONTACT_INSERT, patientContact.dataValues);
    res.send(patientContact);
}));
patientContact.delete('/reminderContact/:id', (0, _expressasynchandler.default)(async (req, res)=>{
    const { models, params } = req;
    req.checkPermission('write', 'Patient');
    const { id } = params;
    await models.PatientContact.update({
        deletedAt: new Date()
    }, {
        where: {
            id
        }
    });
    res.send({
        message: 'Contact deleted successfully'
    });
}));

//# sourceMappingURL=patientContact.js.map