"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "syncHealth", {
    enumerable: true,
    get: function() {
        return syncHealth;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _CentralServerConnection = require("../../sync/CentralServerConnection");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const syncHealth = _express.default.Router();
syncHealth.get('/$', (0, _expressasynchandler.default)(async (req, res)=>{
    const { deviceId } = req;
    req.flagPermissionChecked();
    const centralServer = new _CentralServerConnection.CentralServerConnection({
        deviceId
    });
    // The web app and facility server should still work without a connected
    // central, we just want to notify the user they aren't connected to central.
    try {
        // This request will fail if the central servers `versionCompatibility`
        // middleware check fails. We don't need the response, only the error message.
        await centralServer.whoami();
        res.send({
            healthy: true
        });
    } catch (error) {
        // The web client needs to receive this response to alert the user
        // of an out of date central server, but we don't want TamanuApi to catch and throw the error.
        res.send({
            healthy: false,
            error: error.message
        });
    }
}));

//# sourceMappingURL=syncHealth.js.map