"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getLastOrderedAtForOngoingPrescriptions", {
    enumerable: true,
    get: function() {
        return getLastOrderedAtForOngoingPrescriptions;
    }
});
const _lodash = require("lodash");
async function getLastOrderedAtForOngoingPrescriptions(db, ongoingPrescriptionIds, options = {}) {
    if (!ongoingPrescriptionIds?.length) {
        return {};
    }
    const [rows] = await db.query(`
    SELECT
      pop.ongoing_prescription_id,
      MAX(po.date) as last_ordered_at
    FROM pharmacy_order_prescriptions pop
    INNER JOIN pharmacy_orders po ON po.id = pop.pharmacy_order_id
      AND po.deleted_at IS NULL
    WHERE pop.ongoing_prescription_id IN (:ongoingPrescriptionIds)
      AND pop.deleted_at IS NULL
    GROUP BY pop.ongoing_prescription_id
  `, {
        replacements: {
            ongoingPrescriptionIds
        },
        ...options
    });
    return (0, _lodash.keyBy)(rows, 'ongoing_prescription_id');
}

//# sourceMappingURL=medication.js.map