"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "buildSettings", {
    enumerable: true,
    get: function() {
        return buildSettings;
    }
});
const _constants = require("@tamanu/constants");
const _lodash = require("lodash");
const _schema = require("../schema");
const _SettingsDBReader = require("./readers/SettingsDBReader");
const _SettingsJSONReader = require("./readers/SettingsJSONReader");
/** Returns the cascade of applicable settings readers, in descending order of priority */ function getReaderCascade(models, facilityId) {
    return facilityId ? [
        new _SettingsDBReader.SettingsDBReader(models, _constants.SETTINGS_SCOPES.FACILITY, facilityId),
        new _SettingsDBReader.SettingsDBReader(models, _constants.SETTINGS_SCOPES.GLOBAL),
        new _SettingsJSONReader.SettingsJSONReader(_schema.facilityDefaults),
        new _SettingsJSONReader.SettingsJSONReader(_schema.globalDefaults)
    ] : [
        new _SettingsDBReader.SettingsDBReader(models, _constants.SETTINGS_SCOPES.CENTRAL),
        new _SettingsDBReader.SettingsDBReader(models, _constants.SETTINGS_SCOPES.GLOBAL),
        new _SettingsJSONReader.SettingsJSONReader(_schema.centralDefaults),
        new _SettingsJSONReader.SettingsJSONReader(_schema.globalDefaults)
    ];
}
async function buildSettings(models, facilityId) {
    const readers = getReaderCascade(models, facilityId);
    let settings = {};
    for (const reader of readers){
        const value = await reader.getSettings();
        if (value) {
            settings = (0, _lodash.mergeWith)(value, settings, (_, settingValue)=>(0, _lodash.isArray)(settingValue) ? settingValue : undefined);
        }
    }
    return settings;
}

//# sourceMappingURL=buildSettings.js.map