"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    thresholdsDefault: function() {
        return thresholdsDefault;
    },
    thresholdsSchema: function() {
        return thresholdsSchema;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _constants = require("@tamanu/constants");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const thresholdsSchema = _yup.array(_yup.object({
    threshold: _yup.mixed().test('is-number-or-infinity', 'Threshold must be a number or -Infinity', (value)=>typeof value === 'number' || value === '-Infinity').required(),
    status: _yup.string().oneOf(Object.values(_constants.VACCINE_STATUS)).required()
}));
const thresholdsDefault = [
    {
        threshold: 28,
        status: _constants.VACCINE_STATUS.SCHEDULED
    },
    {
        threshold: 7,
        status: _constants.VACCINE_STATUS.UPCOMING
    },
    {
        threshold: -7,
        status: _constants.VACCINE_STATUS.DUE
    },
    {
        threshold: -55,
        status: _constants.VACCINE_STATUS.OVERDUE
    },
    {
        threshold: '-Infinity',
        status: _constants.VACCINE_STATUS.MISSED
    }
];

//# sourceMappingURL=upcomingVaccinations.js.map