import { SETTINGS_SCOPES } from '@tamanu/constants';
import { isArray, mergeWith } from 'lodash';
import { centralDefaults, facilityDefaults, globalDefaults } from '../schema';
import { SettingsDBReader } from './readers/SettingsDBReader';
import { SettingsJSONReader } from './readers/SettingsJSONReader';
/** Returns the cascade of applicable settings readers, in descending order of priority */ function getReaderCascade(models, facilityId) {
    return facilityId ? [
        new SettingsDBReader(models, SETTINGS_SCOPES.FACILITY, facilityId),
        new SettingsDBReader(models, SETTINGS_SCOPES.GLOBAL),
        new SettingsJSONReader(facilityDefaults),
        new SettingsJSONReader(globalDefaults)
    ] : [
        new SettingsDBReader(models, SETTINGS_SCOPES.CENTRAL),
        new SettingsDBReader(models, SETTINGS_SCOPES.GLOBAL),
        new SettingsJSONReader(centralDefaults),
        new SettingsJSONReader(globalDefaults)
    ];
}
export async function buildSettings(models, facilityId) {
    const readers = getReaderCascade(models, facilityId);
    let settings = {};
    for (const reader of readers){
        const value = await reader.getSettings();
        if (value) {
            settings = mergeWith(value, settings, (_, settingValue)=>isArray(settingValue) ? settingValue : undefined);
        }
    }
    return settings;
}

//# sourceMappingURL=buildSettings.js.map