"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    PatientAdditionalDataSchema: function() {
        return PatientAdditionalDataSchema;
    },
    PatientSchema: function() {
        return PatientSchema;
    },
    PatientWithAdditionalDataSchema: function() {
        return PatientWithAdditionalDataSchema;
    }
});
const _zod = require("zod");
const _constants = require("@tamanu/constants");
const _referenceDataschema = require("./referenceData.schema");
const PatientAdditionalDataSchema = _zod.z.object({
    id: _zod.z.string(),
    patientId: _zod.z.string(),
    placeOfBirth: _zod.z.string().nullish(),
    bloodType: _zod.z.string().nullish(),
    primaryContactNumber: _zod.z.string().nullish(),
    secondaryContactNumber: _zod.z.string().nullish(),
    maritalStatus: _zod.z.string().nullish(),
    cityTown: _zod.z.string().nullish(),
    streetVillage: _zod.z.string().nullish(),
    educationalLevel: _zod.z.string().nullish(),
    socialMedia: _zod.z.string().nullish(),
    title: _zod.z.string().nullish(),
    birthCertificate: _zod.z.string().nullish(),
    drivingLicense: _zod.z.string().nullish(),
    passport: _zod.z.string().nullish(),
    passportNumber: _zod.z.string().nullish(),
    emergencyContactName: _zod.z.string().nullish(),
    emergencyContactNumber: _zod.z.string().nullish(),
    motherId: _zod.z.string().nullish(),
    fatherId: _zod.z.string().nullish(),
    healthCenterId: _zod.z.string().nullish(),
    secondaryVillageId: _zod.z.string().nullish(),
    updatedAtByField: _zod.z.record(_zod.z.string(), _zod.z.any()).nullish(),
    insurerPolicyNumber: _zod.z.string().nullish(),
    registeredById: _zod.z.string().nullish(),
    nationalityId: _zod.z.string().nullish(),
    countryId: _zod.z.string().nullish(),
    divisionId: _zod.z.string().nullish(),
    subdivisionId: _zod.z.string().nullish(),
    medicalAreaId: _zod.z.string().nullish(),
    nursingZoneId: _zod.z.string().nullish(),
    settlementId: _zod.z.string().nullish(),
    ethnicityId: _zod.z.string().nullish(),
    occupationId: _zod.z.string().nullish(),
    religionId: _zod.z.string().nullish(),
    patientBillingTypeId: _zod.z.string().nullish(),
    countryOfBirthId: _zod.z.string().nullish(),
    insurerId: _zod.z.string().nullish(),
    // Reference data relations
    nationality: _referenceDataschema.ReferenceDataSchema.nullish(),
    country: _referenceDataschema.ReferenceDataSchema.nullish(),
    division: _referenceDataschema.ReferenceDataSchema.nullish(),
    subdivision: _referenceDataschema.ReferenceDataSchema.nullish(),
    medicalArea: _referenceDataschema.ReferenceDataSchema.nullish(),
    nursingZone: _referenceDataschema.ReferenceDataSchema.nullish(),
    settlement: _referenceDataschema.ReferenceDataSchema.nullish(),
    ethnicity: _referenceDataschema.ReferenceDataSchema.nullish(),
    occupation: _referenceDataschema.ReferenceDataSchema.nullish(),
    religion: _referenceDataschema.ReferenceDataSchema.nullish(),
    patientBillingType: _referenceDataschema.ReferenceDataSchema.nullish(),
    countryOfBirth: _referenceDataschema.ReferenceDataSchema.nullish(),
    insurer: _referenceDataschema.ReferenceDataSchema.nullish()
});
const PatientSchema = _zod.z.object({
    id: _zod.z.string(),
    displayId: _zod.z.string(),
    firstName: _zod.z.string(),
    middleName: _zod.z.string().nullish(),
    lastName: _zod.z.string(),
    dateOfBirth: _zod.z.string(),
    sex: _zod.z.enum(_constants.SEX_VALUES),
    village: _referenceDataschema.ReferenceDataSchema.nullish()
});
const PatientWithAdditionalDataSchema = PatientSchema.extend({
    additionalData: PatientAdditionalDataSchema.nullish()
});

//# sourceMappingURL=patient.schema.js.map