"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirContactPoint", {
    enumerable: true,
    get: function() {
        return FhirContactPoint;
    }
});
const _lodash = require("lodash");
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _baseType = require("./baseType");
const _period = require("./period");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const SYSTEMS = [
    'phone',
    'fax',
    'email',
    'pager',
    'url',
    'sms',
    'other'
];
const USES = [
    'home',
    'work',
    'temp',
    'old',
    'mobile'
];
let FhirContactPoint = class FhirContactPoint extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            system: _yup.string().oneOf([
                null,
                ...SYSTEMS
            ]).nullable().default(null),
            value: _yup.string().nullable().default(null),
            use: _yup.string().oneOf([
                null,
                ...USES
            ]).nullable().default(null),
            rank: _yup.number().positive().integer().min(1).nullable().default(null),
            period: _period.FhirPeriod.asYup().nullable().default(null)
        }).noUnknown();
    }
    static fake(model, { fieldName }, id) {
        return new this({
            system: (0, _lodash.sample)(SYSTEMS),
            value: `${model.name}.${fieldName}.${id}`,
            use: (0, _lodash.sample)(USES),
            rank: (0, _lodash.random)(1, 10)
        });
    }
};

//# sourceMappingURL=contactPoint.js.map