"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "FhirPeriod", {
    enumerable: true,
    get: function() {
        return FhirPeriod;
    }
});
const _lodash = require("lodash");
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _fhir = require("../../utils/fhir");
const _baseType = require("./baseType");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
let FhirPeriod = class FhirPeriod extends _baseType.FhirBaseType {
    static SCHEMA() {
        return _yup.object({
            start: _yup.string().nullable().default(null),
            end: _yup.string().when('start', (start, schema)=>start ? schema.test('is-later-than-start', 'end must be later than start', (end)=>end === null || end > start) : schema).nullable().default(null)
        }).noUnknown();
    }
    static fake() {
        const end = (0, _lodash.random)(0, Date.now());
        const start = end - (0, _lodash.random)(0, end);
        return new this({
            start: (0, _fhir.formatFhirDate)(new Date(start)),
            end: (0, _fhir.formatFhirDate)(new Date(end))
        });
    }
};

//# sourceMappingURL=period.js.map