"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "errorHandlerProblem", {
    enumerable: true,
    get: function() {
        return errorHandlerProblem;
    }
});
const _nodecrypto = require("node:crypto");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _sequelize = require("sequelize");
const _errors = require("@tamanu/errors");
const _logging = require("../services/logging");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function errorHandlerProblem(error, req, { convertDatabaseError }) {
    if (error instanceof _sequelize.BaseError) {
        error = convertDatabaseError(error);
    }
    const exposeSensitive = process.env.NODE_ENV !== 'production' || typeof _config.default.debugging.apiErrorsToken === 'string' && _config.default.debugging.apiErrorsToken.length > 0 && (0, _nodecrypto.timingSafeEqual)(Buffer.from(req.get('tamanu-debug') ?? ''), Buffer.from(_config.default.debugging.apiErrorsToken ?? ''));
    const problem = (error instanceof _errors.Problem ? error : _errors.Problem.fromError(error)).excludeSensitiveFields(!exposeSensitive);
    if (problem.type.includes(_errors.ERROR_TYPE.AUTH)) {
        _logging.log.warn(`Error ${problem.status} (${problem.type}): ${error.message}`);
    } else if (problem.status >= 500) {
        _logging.log.error(`Error ${problem.status} (${problem.type}): `, error);
    } else {
        _logging.log.info(`Error ${problem.status} (${problem.type}): `, error);
    }
    return {
        problem,
        json: {
            // RFC 7807 Problem Details for HTTP APIs
            ...problem.toJSON(),
            // legacy error format
            error: {
                message: error.message,
                name: error.name,
                status: problem.status
            }
        }
    };
}

//# sourceMappingURL=errorHandlerProblem.js.map