"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getResponseJsonSafely", {
    enumerable: true,
    get: function() {
        return getResponseJsonSafely;
    }
});
const _logging = require("../services/logging");
const getResponseJsonSafely = async (response)=>{
    try {
        return await response.json();
    } catch (e) {
        if (response.headers.get('content-type') === 'text/html') {
            // the server will respond with html instead of json for the
            // nginx "server unavailable" error page; this handles that
            return {
                error: {
                    message: response.statusText
                }
            };
        }
        // log json parsing errors, but still return a valid object
        _logging.log.warn(`getResponseJsonSafely: Error parsing JSON: ${e}`);
        return {};
    }
};

//# sourceMappingURL=getResponseJsonSafely.js.map