"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "HandoverNotesPDF", {
    enumerable: true,
    get: function() {
        return HandoverNotesPDF;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _Layout = require("../patientCertificates/Layout");
const _HandoverHeaderSection = require("./HandoverHeaderSection");
const _HandoverPatient = require("./HandoverPatient");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const HandoverNotesPDFComponent = ({ handoverNotes = [], locationGroupName, logoSrc, getLocalisation, getSetting, letterheadConfig })=>/*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: _Layout.styles.page
    }, /*#__PURE__*/ _react.default.createElement(_HandoverHeaderSection.HandoverHeaderSection, {
        letterheadConfig: letterheadConfig,
        locationGroupName: locationGroupName,
        logoSrc: logoSrc
    }), /*#__PURE__*/ _react.default.createElement(_Layout.Box, {
        mb: 0
    }, handoverNotes.map(({ patient, diagnosis, notes, location, createdAt, isEdited, arrivalDate })=>/*#__PURE__*/ _react.default.createElement(_HandoverPatient.HandoverPatient, {
            key: `patient-notes-${patient.displayId}`,
            patient: patient,
            location: location,
            createdAt: createdAt,
            diagnosis: diagnosis,
            arrivalDate: arrivalDate,
            notes: notes,
            isEdited: isEdited,
            getLocalisation: getLocalisation,
            getSetting: getSetting
        })))));
const HandoverNotesPDF = (0, _languageContext.withLanguageContext)(HandoverNotesPDFComponent);

//# sourceMappingURL=HandoverNotesPDF.js.map