"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getInvoiceItemCoveragePercentage: function() {
        return getInvoiceItemCoveragePercentage;
    },
    getInvoiceItemNetCost: function() {
        return getInvoiceItemNetCost;
    },
    getInvoiceItemPrice: function() {
        return getInvoiceItemPrice;
    },
    getInvoiceItemTotalDiscountedPrice: function() {
        return getInvoiceItemTotalDiscountedPrice;
    },
    getInvoiceItemTotalPrice: function() {
        return getInvoiceItemTotalPrice;
    },
    getItemAdjustmentAmount: function() {
        return getItemAdjustmentAmount;
    },
    getItemSingleInsuranceCoverageAmount: function() {
        return getItemSingleInsuranceCoverageAmount;
    },
    getItemTotalInsuranceCoverageAmount: function() {
        return getItemTotalInsuranceCoverageAmount;
    },
    hasItemAdjustment: function() {
        return hasItemAdjustment;
    }
});
const _decimal = /*#__PURE__*/ _interop_require_default(require("decimal.js"));
const _constants = require("@tamanu/constants");
const _discount = require("./discount");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getInvoiceItemPrice = (invoiceItem)=>{
    return invoiceItem.priceFinal ?? invoiceItem.manualEntryPrice ?? invoiceItem?.product?.invoicePriceListItem?.price ?? 0 // handle missing price as 0
    ;
};
const getInvoiceItemTotalPrice = (invoiceItem)=>{
    const price = getInvoiceItemPrice(invoiceItem) || 0;
    const quantity = invoiceItem.quantity || 0;
    return new _decimal.default(price).times(quantity).toNumber();
};
const getInvoiceItemTotalDiscountedPrice = (invoiceItem)=>{
    const invoiceItemTotalPrice = getInvoiceItemTotalPrice(invoiceItem);
    if (!invoiceItem.discount) return invoiceItemTotalPrice;
    if (invoiceItem.discount.type === _constants.INVOICE_ITEMS_DISCOUNT_TYPES.PERCENTAGE) {
        return (0, _discount.getDiscountedPrice)(invoiceItemTotalPrice, invoiceItem?.discount?.amount || 0);
    }
    return invoiceItemTotalPrice - (invoiceItem?.discount?.amount || 0);
};
const getItemAdjustmentAmount = (item)=>{
    const originalPrice = getInvoiceItemTotalPrice(item) || 0;
    const discountedPrice = getInvoiceItemTotalDiscountedPrice(item) || 0;
    return new _decimal.default(discountedPrice).minus(originalPrice).toNumber();
};
const hasItemAdjustment = (item)=>{
    return getItemAdjustmentAmount(item) !== 0;
};
const getItemTotalInsuranceCoverageAmount = (item)=>{
    if (!item?.product?.insurable || !item.insurancePlanItems?.length) {
        return 0;
    }
    const discountedPrice = getInvoiceItemTotalDiscountedPrice(item) || 0;
    const totalCoverage = item.insurancePlanItems.reduce((sum, insurancePlanItem)=>{
        const coverageForRow = getItemSingleInsuranceCoverageAmount(discountedPrice, item, insurancePlanItem);
        return sum.plus(coverageForRow);
    }, new _decimal.default(0));
    // Cap coverage at the discounted price
    return Math.min(totalCoverage, discountedPrice);
};
const getItemSingleInsuranceCoverageAmount = (discountedPrice, item, insurancePlanItem)=>{
    const appliedCoverage = getInvoiceItemCoveragePercentage(item, insurancePlanItem);
    return new _decimal.default(discountedPrice).times(appliedCoverage / 100).toNumber();
};
const getInvoiceItemNetCost = (item)=>{
    const discountedPrice = getInvoiceItemTotalDiscountedPrice(item) || 0;
    const insuranceCoverage = getItemTotalInsuranceCoverageAmount(item);
    return new _decimal.default(discountedPrice).minus(insuranceCoverage).toNumber();
};
const getInvoiceItemCoveragePercentage = (item, insurancePlanItem)=>{
    const planCoverageValue = insurancePlanItem.coverageValue ?? 0;
    if (!item.finalisedInsurances || item.finalisedInsurances.length === 0) {
        return planCoverageValue;
    }
    const finalisedInsurance = item.finalisedInsurances.find((ins)=>ins.invoiceInsurancePlanId === insurancePlanItem.id);
    return finalisedInsurance ? finalisedInsurance.coverageValueFinal : planCoverageValue;
};

//# sourceMappingURL=invoiceItem.js.map