"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "DeathCertificatePrintout", {
    enumerable: true,
    get: function() {
        return DeathCertificatePrintout;
    }
});
const _proptypes = /*#__PURE__*/ _interop_require_default(require("prop-types"));
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _patientAccessors = require("../patientAccessors");
const _Layout = require("./Layout");
const _LetterheadSection = require("./LetterheadSection");
const _Footer = require("./printComponents/Footer");
const _MultiPageHeader = require("./printComponents/MultiPageHeader");
const _renderDataItems = require("./printComponents/renderDataItems");
const _Typography = require("./Typography");
const _getDisplayDate = require("./getDisplayDate");
const _DataSection = require("./printComponents/DataSection");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _Text = require("../pdf/Text");
const _datefns = require("date-fns");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const borderStyle = '1 solid black';
const tableLabelWidth = 200;
const tablePadding = 10;
const dataColPadding = 10;
const generalStyles = _renderer.StyleSheet.create({
    container: {
        marginVertical: 8
    },
    tableContainer: {
        marginTop: 30
    },
    sectionContainer: {
        marginVertical: 7
    }
});
const TableContainer = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            generalStyles.container,
            generalStyles.tableContainer
        ],
        ...props
    });
const infoBoxStyles = _renderer.StyleSheet.create({
    row: {
        flexDirection: 'row',
        border: borderStyle,
        marginBottom: -1
    },
    labelCol: {
        width: tableLabelWidth,
        padding: tablePadding
    },
    dataCol: {
        flex: 1,
        padding: dataColPadding,
        paddingBottom: 30
    },
    boldText: {
        fontSize: 12
    },
    infoText: {
        fontSize: 12
    },
    italicBoldText: {
        fontStyle: 'italic',
        fontSize: 12,
        fontWeight: 700
    },
    italicText: {
        fontSize: 12,
        fontWeight: 400
    },
    underlinedText: {
        borderBottom: borderStyle,
        width: 175
    },
    marginTop: {
        marginTop: 50
    },
    mediumMarginTop: {
        marginTop: 30
    },
    smallMarginTop: {
        marginTop: 5
    }
});
const signStyles = _renderer.StyleSheet.create({
    container: {
        paddingBottom: 20,
        marginVertical: 30
    },
    text: {
        fontSize: 12,
        lineHeight: 1
    },
    line: {
        flex: 1,
        borderBottom: '1 solid black',
        height: 14,
        marginLeft: 5
    },
    row: {
        flexDirection: 'row',
        paddingTop: 20
    },
    leftCol: {
        flexDirection: 'row',
        width: 300,
        paddingRight: 20
    },
    rightCol: {
        flexDirection: 'row',
        flex: 1
    }
});
const InfoBoxRow = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: infoBoxStyles.row,
        ...props
    });
const InfoBoxLabelCol = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: infoBoxStyles.labelCol,
        ...props
    });
const UnderlinedText = ({ text, style, props })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            ...infoBoxStyles.infoText,
            ...infoBoxStyles.underlinedText,
            ...style
        },
        ...props
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, null, text));
const CauseField = ({ cause, label, helperText, ...props })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, props, /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, label && /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: infoBoxStyles.infoText
    }, "(", label, ") "), /*#__PURE__*/ _react.default.createElement(UnderlinedText, {
        text: cause.name
    }, " "), /*#__PURE__*/ _react.default.createElement(UnderlinedText, {
        text: (0, _datefns.formatDistanceStrict)(0, (0, _datefns.milliseconds)({
            minutes: cause.timeAfterOnset
        })),
        style: {
            width: 85,
            marginLeft: 10
        }
    })), helperText && /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: [
            infoBoxStyles.infoText,
            infoBoxStyles.smallMarginTop
        ]
    }, helperText));
};
const InfoBoxDataCol = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: infoBoxStyles.dataCol,
        ...props
    });
const AuthorisedAndSignSection = ()=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signStyles.container
    }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signStyles.row
    }, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        bold: true,
        style: signStyles.text
    }, getTranslation('pdf.deathCertificate.signature.authorisedBy', 'Authorised by (print name)'), ":"), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signStyles.line
    })), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signStyles.row
    }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signStyles.leftCol
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: true,
        style: signStyles.text
    }, getTranslation('pdf.deathCertificate.signature.signed', 'Signed'), ":", ' '), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signStyles.line
    })), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signStyles.rightCol
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: true,
        style: signStyles.text
    }, getTranslation('pdf.deathCertificate.signature.date', 'Date'), ":"), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: signStyles.line
    }))));
};
const placeOfDeathAccessor = ({ facility })=>{
    return facility?.name;
};
const getCauseName = (cause)=>cause?.condition?.name;
const getCauseInfo = (cause)=>{
    const name = cause?.condition?.name;
    const timeAfterOnset = cause?.timeAfterOnset;
    return {
        name,
        timeAfterOnset
    };
};
const causeOfDeathAccessor = ({ causes })=>{
    return getCauseName(causes?.primary);
};
// Death certificate has a slightly different DOB format to other certificates so needs its own accessor
const getDob = ({ dateOfBirth }, getLocalisation, getTranslation)=>dateOfBirth ? (0, _getDisplayDate.getDisplayDate)(dateOfBirth, 'd MMM yyyy', getLocalisation) : getTranslation('general.fallback.unknown', 'Unknown');
const getDateAndTimeOfDeath = (patientData, getLocalisation, getTranslation)=>{
    return `${(0, _patientAccessors.getDateOfDeath)(patientData, {
        getLocalisation,
        getTranslation
    })} ${(0, _patientAccessors.getTimeOfDeath)(patientData, {
        getLocalisation,
        getTranslation
    })}`;
};
const PATIENT_DETAIL_FIELDS = {
    leftCol: [
        {
            key: 'firstName',
            label: 'First name'
        },
        {
            key: 'lastName',
            label: 'Last name'
        },
        {
            key: 'nationalityId',
            label: 'Nationality',
            accessor: _patientAccessors.getNationality
        },
        {
            key: 'address',
            label: 'Address',
            accessor: _patientAccessors.getAddress
        }
    ],
    rightCol: [
        {
            key: 'sex',
            label: 'Sex',
            accessor: _patientAccessors.getSex
        },
        {
            key: 'dateOfBirth',
            label: 'DOB',
            accessor: getDob
        },
        {
            key: 'ethnicityId',
            label: 'Ethnicity',
            accessor: _patientAccessors.getEthnicity
        },
        {
            key: 'villageId',
            label: 'Village',
            accessor: _patientAccessors.getVillage
        }
    ]
};
const PATIENT_DEATH_DETAILS = {
    leftCol: [
        {
            key: 'deathDateAndTime',
            label: 'Date & time of death',
            accessor: getDateAndTimeOfDeath
        },
        {
            key: 'placeOfDeath',
            label: 'Place of death',
            accessor: placeOfDeathAccessor
        }
    ],
    rightCol: [
        {
            key: 'causeOfDeath',
            label: 'Cause of death',
            accessor: causeOfDeathAccessor
        },
        {
            key: 'attendingClinician',
            label: 'Attending clinician',
            accessor: _patientAccessors.getClinician
        }
    ]
};
const SectionContainer = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: generalStyles.sectionContainer,
        ...props
    });
const DeathCertificatePrintoutComponent = /*#__PURE__*/ _react.default.memo(({ patientData, certificateData, getLocalisation })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    const { logo, deathCertFooterImg } = certificateData;
    const { causes } = patientData;
    const causeOfDeath = getCauseInfo(causes?.primary);
    const antecedentCause1 = getCauseInfo(causes?.antecedent1);
    const antecedentCause2 = getCauseInfo(causes?.antecedent2);
    const antecedentCause3 = getCauseInfo(causes?.antecedent3);
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: {
            ..._Layout.styles.page,
            paddingBottom: 25
        }
    }, /*#__PURE__*/ _react.default.createElement(_MultiPageHeader.MultiPageHeader, {
        documentName: getTranslation('pdf.deathCertificate.title', 'Cause of death certificate'),
        patientName: (0, _patientAccessors.getName)(patientData),
        patientId: patientData.displayId
    }), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        logoSrc: logo,
        letterheadConfig: certificateData,
        certificateTitle: getTranslation('pdf.deathCertificate.title', 'Cause of death certificate')
    }), /*#__PURE__*/ _react.default.createElement(SectionContainer, null, /*#__PURE__*/ _react.default.createElement(_DataSection.DataSection, {
        title: getTranslation('pdf.deathCertificate.section.patientDetails', 'Patient details'),
        hideBottomRule: true
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, (0, _renderDataItems.renderDataItems)(PATIENT_DETAIL_FIELDS.leftCol, patientData, getLocalisation, getTranslation, 12)), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, (0, _renderDataItems.renderDataItems)(PATIENT_DETAIL_FIELDS.rightCol, patientData, getLocalisation, getTranslation, 12))), /*#__PURE__*/ _react.default.createElement(_DataSection.DataSection, {
        title: ""
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, (0, _renderDataItems.renderDataItems)(PATIENT_DEATH_DETAILS.leftCol, patientData, getLocalisation, getTranslation, 12)), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, (0, _renderDataItems.renderDataItems)(PATIENT_DEATH_DETAILS.rightCol, patientData, getLocalisation, getTranslation, 12))))), /*#__PURE__*/ _react.default.createElement(TableContainer, null, /*#__PURE__*/ _react.default.createElement(InfoBoxRow, null, /*#__PURE__*/ _react.default.createElement(InfoBoxLabelCol, null, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: true,
        style: infoBoxStyles.boldText
    }, getTranslation('pdf.deathCertificate.causeOfDeath.primary.label.1', 'I'), '\n', getTranslation('pdf.deathCertificate.causeOfDeath.primary.label.2', 'Disease or condition directly'), '\n', getTranslation('pdf.deathCertificate.causeOfDeath.primary.label.3', 'leading to death*')), /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: true,
        style: [
            infoBoxStyles.italicBoldText,
            infoBoxStyles.marginTop
        ]
    }, getTranslation('pdf.deathCertificate.antecedentCauses.label', 'Antecedent Causes')), /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: infoBoxStyles.infoText
    }, getTranslation('pdf.deathCertificate.antecedentCauses.description.1', 'Morbid conditions, if any,'), '\n', getTranslation('pdf.deathCertificate.antecedentCauses.description.2', 'giving rise to the above cause,'), '\n', getTranslation('pdf.deathCertificate.antecedentCauses.description.3', 'stating the underlying'), '\n', getTranslation('pdf.deathCertificate.antecedentCauses.description.4', 'condition last'))), /*#__PURE__*/ _react.default.createElement(InfoBoxDataCol, null, /*#__PURE__*/ _react.default.createElement(CauseField, {
        style: infoBoxStyles.mediumMarginTop,
        label: "a",
        helperText: getTranslation('pdf.deathCertificate.antecedentCauses.dueTo', 'due to (or as a consequence of)'),
        cause: causeOfDeath
    }), /*#__PURE__*/ _react.default.createElement(CauseField, {
        style: infoBoxStyles.mediumMarginTop,
        label: "b",
        helperText: getTranslation('pdf.deathCertificate.antecedentCauses.dueTo', 'due to (or as a consequence of)'),
        cause: antecedentCause1
    }), /*#__PURE__*/ _react.default.createElement(CauseField, {
        style: infoBoxStyles.mediumMarginTop,
        label: "c",
        helperText: getTranslation('pdf.deathCertificate.antecedentCauses.dueTo', 'due to (or as a consequence of)'),
        cause: antecedentCause2
    }), /*#__PURE__*/ _react.default.createElement(CauseField, {
        style: infoBoxStyles.mediumMarginTop,
        label: "d",
        cause: antecedentCause3
    }))), /*#__PURE__*/ _react.default.createElement(InfoBoxRow, null, /*#__PURE__*/ _react.default.createElement(InfoBoxLabelCol, null, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: true,
        style: infoBoxStyles.boldText
    }, getTranslation('pdf.deathCertificate.contributingCauses.label.1', 'II'), '\n', getTranslation('pdf.deathCertificate.contributingCauses.label.2', 'Other significant conditions'), '\n', getTranslation('pdf.deathCertificate.contributingCauses.label.3', 'contributing to the death but'), '\n', getTranslation('pdf.deathCertificate.contributingCauses.label.4', 'not related to the disease or'), '\n', getTranslation('pdf.deathCertificate.contributingCauses.label.5', 'condition causing it.'), '\n')), /*#__PURE__*/ _react.default.createElement(InfoBoxDataCol, null, causes?.contributing?.map((cause, index)=>/*#__PURE__*/ _react.default.createElement(CauseField, {
            style: causes?.contributing.length < 3 ? infoBoxStyles.mediumMarginTop : infoBoxStyles.smallMarginTop,
            key: index,
            cause: getCauseInfo(cause)
        }))))), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: generalStyles.container
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: infoBoxStyles.italicText
    }, getTranslation('pdf.deathCertificate.causeOfDeath.note', '* This does not mean the mode of dying, e.g heart failure, respiratory failure. It means the disease, injury, or complication that caused death.'))), deathCertFooterImg ? /*#__PURE__*/ _react.default.createElement(_Layout.SigningImage, {
        src: deathCertFooterImg
    }) : /*#__PURE__*/ _react.default.createElement(AuthorisedAndSignSection, null), /*#__PURE__*/ _react.default.createElement(_Footer.Footer, null)));
});
const DeathCertificatePrintout = (0, _languageContext.withLanguageContext)(DeathCertificatePrintoutComponent);
DeathCertificatePrintout.propTypes = {
    patientData: _proptypes.default.object.isRequired,
    certificateData: _proptypes.default.object.isRequired
};

//# sourceMappingURL=DeathCertificatePrintout.js.map