"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceRecordPrintout", {
    enumerable: true,
    get: function() {
        return InvoiceRecordPrintout;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _lodash = require("lodash");
const _constants = require("@tamanu/constants");
const _dateTime = require("@tamanu/utils/dateTime");
const _Layout = require("./Layout");
const _LetterheadSection = require("./LetterheadSection");
const _MultiPageHeader = require("./printComponents/MultiPageHeader");
const _patientAccessors = require("../patientAccessors");
const _Footer = require("./printComponents/Footer");
const _InvoiceDetails = require("./printComponents/InvoiceDetails");
const _invoice = require("../invoice");
const _languageContext = require("../pdf/languageContext");
const _Page = require("../pdf/Page");
const _Text = require("../pdf/Text");
const _PatientDetails = require("./printComponents/PatientDetails");
const _InvoiceEncounterDetails = require("./printComponents/InvoiceEncounterDetails");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const borderStyle = '1 solid black';
const pageStyles = _renderer.StyleSheet.create({
    body: {
        paddingHorizontal: 30,
        paddingTop: 30,
        paddingBottom: 50
    }
});
const textStyles = _renderer.StyleSheet.create({
    sectionTitle: {
        marginBottom: 3,
        fontSize: 9
    }
});
const baseTableStyles = _renderer.StyleSheet.create({
    table: {
        flexDirection: 'column',
        marginBottom: 5
    },
    heading: {
        paddingLeft: 13,
        paddingTop: 5,
        paddingBottom: 5,
        borderBottom: 'none',
        justifyContent: 'flex-start'
    },
    row: {
        flexDirection: 'row',
        justifyContent: 'space-evenly',
        borderTop: borderStyle,
        borderRight: borderStyle,
        borderLeft: borderStyle,
        borderBottom: borderStyle,
        marginBottom: -1
    },
    baseCell: {
        flexDirection: 'row',
        borderLeft: 'none',
        alignItems: 'flex-start',
        padding: 7
    },
    p: {
        fontSize: 9,
        lineHeight: 1.2
    },
    noteText: {
        fontSize: 7,
        marginTop: 1
    }
});
const paymentTableStyles = _renderer.StyleSheet.create({
    headerRow: {
        borderBottom: 'none',
        borderTop: 'none'
    },
    row: {
        borderBottom: 'none'
    }
});
const invoiceItemTableStyles = _renderer.StyleSheet.create({
    headerRow: {
        borderBottom: 'none',
        borderRight: 'none',
        borderLeft: 'none'
    },
    row: {
        borderBottom: 'none',
        borderRight: 'none',
        borderLeft: 'none'
    }
});
const subRowStyles = _renderer.StyleSheet.create({
    row: {
        flexDirection: 'row',
        justifyContent: 'space-evenly',
        borderRight: 'none',
        borderBottom: 'none',
        marginBottom: -1
    },
    emptyCell: {
        flexDirection: 'row',
        borderLeft: 'none',
        alignItems: 'flex-start',
        padding: 7
    },
    labelText: {
        fontSize: 9,
        lineHeight: 1.2,
        color: '#666666'
    },
    valueText: {
        fontSize: 9,
        lineHeight: 1.2
    }
});
const summaryPaneStyles = _renderer.StyleSheet.create({
    container: {
        width: 220,
        marginLeft: 'auto',
        paddingHorizontal: 7,
        paddingVertical: 3,
        border: borderStyle
    },
    item: {
        flexDirection: 'row',
        justifyContent: 'space-between',
        marginTop: 4.5,
        marginBottom: 4.5
    },
    subItem: {
        width: 56,
        flexDirection: 'row',
        justifyContent: 'space-between'
    }
});
const HorizontalRule = ({ width = '1px' })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            borderBottom: `${width} solid black`
        }
    });
};
const Table = (props)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: baseTableStyles.table,
        ...props
    });
const Row = ({ style, ...props })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            baseTableStyles.row,
            style
        ],
        ...props
    });
const P = ({ style = {}, children, bold })=>/*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: bold,
        style: [
            baseTableStyles.p,
            style
        ]
    }, children);
const Cell = ({ children, style = {} })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            baseTableStyles.baseCell,
            style
        ]
    }, /*#__PURE__*/ _react.default.createElement(P, null, children));
const CustomCellComponent = ({ children, style = {} })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            baseTableStyles.baseCell,
            style
        ]
    }, children);
const getPrice = (item)=>{
    const price = (0, _invoice.getInvoiceItemPriceDisplay)(item);
    return /*#__PURE__*/ _react.default.createElement(P, null, price);
};
const ADJUSTMENT_ROW_HEIGHT = 18;
const ADJUSTMENT_TOP_MARGIN = 5;
/**
 * Cell component for "Ordered by" column that includes adjustment labels when applicable
 */ const OrderedByCellWithAdjustments = ({ children, style, item })=>{
    const showAdjustments = (0, _invoice.hasItemAdjustment)(item);
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            baseTableStyles.baseCell,
            style,
            {
                flexDirection: 'column',
                alignItems: 'flex-start'
            }
        ]
    }, /*#__PURE__*/ _react.default.createElement(P, null, children), showAdjustments && /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            height: ADJUSTMENT_ROW_HEIGHT,
            marginTop: ADJUSTMENT_TOP_MARGIN,
            justifyContent: 'center',
            alignSelf: 'flex-end'
        }
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: subRowStyles.labelText
    }, "Item adjustment")), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            height: ADJUSTMENT_ROW_HEIGHT,
            justifyContent: 'center',
            alignSelf: 'flex-end'
        }
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: subRowStyles.labelText
    }, "Cost after adjustment"))));
};
/**
 * Cell component for "Cost" column that includes adjustment values when applicable
 */ const PriceCellWithAdjustments = ({ children, style, item })=>{
    const showAdjustments = (0, _invoice.hasItemAdjustment)(item);
    const adjustmentAmount = showAdjustments ? (0, _invoice.getItemAdjustmentAmount)(item) : 0;
    const costAfterAdjustment = showAdjustments ? (0, _invoice.getInvoiceItemTotalDiscountedPrice)(item) || 0 : 0;
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            baseTableStyles.baseCell,
            style,
            {
                flexDirection: 'column',
                alignItems: 'flex-end',
                justifyContent: 'flex-start'
            }
        ]
    }, children, showAdjustments && /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            height: ADJUSTMENT_ROW_HEIGHT,
            marginTop: ADJUSTMENT_TOP_MARGIN,
            justifyContent: 'center'
        }
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: subRowStyles.valueText
    }, (0, _invoice.formatDisplayPrice)(adjustmentAmount))), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            height: ADJUSTMENT_ROW_HEIGHT,
            justifyContent: 'center'
        }
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        style: subRowStyles.valueText
    }, (0, _invoice.formatDisplayPrice)(costAfterAdjustment)))));
};
const getInvoiceItemDetails = (item)=>{
    const name = item.product.name;
    const note = item.note;
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(P, null, name)), !!note && /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(P, {
        style: [
            baseTableStyles.noteText
        ]
    }, "Note: ", note)));
};
const HeaderCell = ({ children, style })=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            baseTableStyles.baseCell,
            style
        ]
    }, /*#__PURE__*/ _react.default.createElement(P, {
        bold: true
    }, children));
const SectionSpacing = ({ minPresenceAhead = 70 })=>// Between sections, ensure we have enough space for the fixed header
    /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            paddingBottom: '10px'
        },
        minPresenceAhead: minPresenceAhead
    });
const getInsurerPaymentStatus = (insurerPayment)=>{
    if (insurerPayment?.status === _constants.INVOICE_INSURER_PAYMENT_STATUSES.REJECTED) {
        return /*#__PURE__*/ _react.default.createElement(P, null, `${(0, _lodash.capitalize)(insurerPayment?.status)}${insurerPayment?.reason ? ` (${insurerPayment?.reason})` : ''}`);
    }
    return (0, _lodash.capitalize)(insurerPayment?.status);
};
const COLUMNS = {
    invoiceItems: [
        {
            key: 'orderDate',
            title: 'Date',
            style: {
                width: '14%'
            },
            accessor: ({ orderDate })=>orderDate ? (0, _dateTime.formatShort)(orderDate) : '--/--/----'
        },
        {
            key: 'productName',
            title: 'Details',
            style: {
                width: '24%'
            },
            accessor: (row)=>getInvoiceItemDetails(row),
            CellComponent: CustomCellComponent
        },
        {
            key: 'quantity',
            title: 'Quantity',
            style: {
                width: '12%'
            },
            accessor: ({ quantity })=>quantity
        },
        {
            key: 'approved',
            title: 'Approved',
            style: {
                width: '13%'
            },
            accessor: ({ approved })=>approved ? 'Y' : ''
        },
        {
            key: 'orderedBy',
            title: 'Ordered by',
            accessor: ({ orderedByUser })=>orderedByUser?.displayName,
            style: {
                width: '24%'
            },
            CellComponent: OrderedByCellWithAdjustments
        },
        {
            key: 'price',
            title: 'Cost',
            accessor: (row)=>getPrice(row),
            style: {
                width: '10%',
                justifyContent: 'flex-end'
            },
            CellComponent: PriceCellWithAdjustments
        },
        {
            key: 'insurance',
            title: 'Insurance',
            accessor: (row)=>(0, _invoice.getFormattedInvoiceItemCoverageAmount)(row),
            style: {
                width: '13%',
                justifyContent: 'flex-end'
            }
        },
        {
            key: 'netCost',
            title: 'Net cost',
            accessor: (row)=>(0, _invoice.getFormattedInvoiceItemNetCost)(row),
            style: {
                width: '12%',
                justifyContent: 'flex-end'
            }
        }
    ],
    patientPayments: [
        {
            key: 'date',
            title: 'Date',
            style: {
                width: '14%',
                paddingLeft: 13
            },
            accessor: ({ date })=>date ? (0, _dateTime.formatShort)(date) : '--/--/----'
        },
        {
            key: 'methodName',
            title: 'Method',
            style: {
                width: '28%'
            },
            accessor: ({ patientPayment })=>patientPayment?.method?.name
        },
        {
            key: 'amount',
            title: 'Amount',
            style: {
                width: '15%'
            },
            accessor: ({ amount })=>amount
        },
        {
            key: 'receiptNumber',
            title: 'Receipt number',
            accessor: ({ receiptNumber })=>receiptNumber,
            style: {
                width: '21%'
            }
        },
        {
            key: 'status',
            title: 'Status',
            accessor: ()=>'Paid',
            style: {
                width: '21%'
            }
        }
    ],
    insurerPayments: [
        {
            key: 'date',
            title: 'Date',
            style: {
                width: '15%',
                paddingLeft: 13
            },
            accessor: ({ date })=>date ? (0, _dateTime.formatShort)(date) : '--/--/----'
        },
        {
            key: 'insurerName',
            title: 'Payer',
            style: {
                width: '17%'
            },
            accessor: ({ insurerPayment })=>insurerPayment?.insurer?.name
        },
        {
            key: 'amount',
            title: 'Amount',
            style: {
                width: '11%'
            },
            accessor: ({ amount })=>amount
        },
        {
            key: 'receiptNumber',
            title: 'Receipt number',
            accessor: ({ receiptNumber })=>receiptNumber,
            style: {
                width: '14%'
            }
        },
        {
            key: 'remainingBalance',
            title: 'Remaining balance',
            accessor: ({ remainingBalance })=>remainingBalance,
            style: {
                width: '13%'
            }
        },
        {
            key: 'status',
            title: 'Status',
            accessor: ({ insurerPayment })=>getInsurerPaymentStatus(insurerPayment),
            style: {
                width: '30%'
            }
        }
    ]
};
const MultipageTableHeading = ({ title, style = textStyles.sectionTitle })=>{
    let firstPageOccurrence = Number.MAX_SAFE_INTEGER;
    return /*#__PURE__*/ _react.default.createElement(Row, {
        style: baseTableStyles.heading
    }, /*#__PURE__*/ _react.default.createElement(_Text.Text, {
        bold: true,
        fixed: true,
        style: style,
        render: ({ pageNumber, subPageNumber })=>{
            if (pageNumber < firstPageOccurrence && subPageNumber) {
                firstPageOccurrence = pageNumber;
            }
            return pageNumber === firstPageOccurrence ? title : `${title} cont...`;
        }
    }));
};
const DataTableHeadingBorder = ()=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            paddingLeft: 7,
            paddingRight: 7
        }
    }, /*#__PURE__*/ _react.default.createElement(HorizontalRule, null));
};
const HeaderRow = ({ columns, style })=>{
    return /*#__PURE__*/ _react.default.createElement(Row, {
        wrap: false,
        style: style
    }, columns.map(({ key, title, style }, colIndex)=>/*#__PURE__*/ _react.default.createElement(HeaderCell, {
            key: key,
            style: style,
            isFirst: colIndex === 0,
            isLast: colIndex === columns.length - 1
        }, title)));
};
const PaymentDataTableHeading = ({ columns, title })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        fixed: true
    }, title && /*#__PURE__*/ _react.default.createElement(MultipageTableHeading, {
        title: title
    }), /*#__PURE__*/ _react.default.createElement(DataTableHeadingBorder, null), /*#__PURE__*/ _react.default.createElement(HeaderRow, {
        columns: columns,
        style: paymentTableStyles.headerRow
    }), /*#__PURE__*/ _react.default.createElement(DataTableHeadingBorder, null));
};
const InvoiceItemDataTableHeading = ({ columns, title })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, title && /*#__PURE__*/ _react.default.createElement(MultipageTableHeading, {
        title: title
    }), /*#__PURE__*/ _react.default.createElement(HeaderRow, {
        columns: columns,
        style: invoiceItemTableStyles.headerRow
    }));
};
const RowWrapper = ({ row, columns, style, SubRowsComponent })=>/*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(Row, {
        wrap: false,
        style: style
    }, columns.map(({ key, accessor, style, CellComponent }, colIndex)=>{
        const displayValue = accessor ? accessor(row) : row[key] || '';
        const isFirst = colIndex === 0;
        const isLast = colIndex === columns.length - 1;
        if (CellComponent) {
            return /*#__PURE__*/ _react.default.createElement(CellComponent, {
                key: key,
                style: style,
                isFirst: isFirst,
                isLast: isLast,
                item: row
            }, displayValue);
        }
        return /*#__PURE__*/ _react.default.createElement(Cell, {
            key: key,
            style: style,
            isFirst: isFirst,
            isLast: isLast
        }, displayValue);
    })), SubRowsComponent && /*#__PURE__*/ _react.default.createElement(SubRowsComponent, {
        item: row,
        columns: columns
    }));
const InvoiceItemTable = ({ data, columns, title })=>/*#__PURE__*/ _react.default.createElement(Table, null, /*#__PURE__*/ _react.default.createElement(InvoiceItemDataTableHeading, {
        columns: columns,
        title: title
    }), data.map((row)=>{
        return /*#__PURE__*/ _react.default.createElement(RowWrapper, {
            key: row.id,
            row: row,
            columns: columns,
            style: invoiceItemTableStyles.row
        });
    }));
const PaymentTable = ({ data, columns, title })=>/*#__PURE__*/ _react.default.createElement(Table, null, /*#__PURE__*/ _react.default.createElement(PaymentDataTableHeading, {
        columns: columns,
        title: title
    }), data.map((row, rowIndex)=>{
        const isLastRow = rowIndex === data.length - 1;
        const rowStyle = {
            borderTop: 'none',
            borderBottom: isLastRow ? borderStyle : 'none'
        };
        return /*#__PURE__*/ _react.default.createElement(RowWrapper, {
            key: row.id,
            row: row,
            columns: columns,
            style: rowStyle
        });
    }));
const InvoiceItemTableSection = ({ title, data, columns })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        minPresenceAhead: 70
    }), /*#__PURE__*/ _react.default.createElement(InvoiceItemTable, {
        data: data,
        columns: columns,
        title: title
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null));
};
const PaymentTableSection = ({ title, data, columns })=>{
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, null, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        minPresenceAhead: 70
    }), /*#__PURE__*/ _react.default.createElement(PaymentTable, {
        data: data,
        columns: columns,
        title: title
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null));
};
const SummaryPane = ({ invoice })=>{
    const { invoiceItemsUndiscountedTotal, patientPaymentRemainingBalance, patientSubtotal, patientPaymentsTotal, itemAdjustmentsTotal } = (0, _invoice.getInvoiceSummary)(invoice);
    const insurancePlanCoverages = (0, _invoice.getFormattedCoverageAmountPerInsurancePlanForInvoice)(invoice);
    const patientPaymentsTotalDisplay = patientPaymentsTotal > 0 ? patientPaymentsTotal * -1 : 0;
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        wrap: false,
        style: summaryPaneStyles.container
    }, /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.item
    }, /*#__PURE__*/ _react.default.createElement(P, null, "Invoice total"), /*#__PURE__*/ _react.default.createElement(P, null, (0, _invoice.formatDisplayPrice)(invoiceItemsUndiscountedTotal))), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.item
    }, /*#__PURE__*/ _react.default.createElement(P, null, "Item adjustments"), /*#__PURE__*/ _react.default.createElement(P, null, (0, _invoice.formatDisplayPrice)(itemAdjustmentsTotal))), insurancePlanCoverages.length > 0 && /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(P, {
        bold: true
    }, "Insurance coverage"), insurancePlanCoverages.map((plan)=>/*#__PURE__*/ _react.default.createElement(_renderer.View, {
            key: plan.id,
            style: summaryPaneStyles.item
        }, /*#__PURE__*/ _react.default.createElement(P, null, plan.name || plan.code), /*#__PURE__*/ _react.default.createElement(P, null, plan.totalCoverage)))), /*#__PURE__*/ _react.default.createElement(HorizontalRule, null), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.item
    }, /*#__PURE__*/ _react.default.createElement(P, {
        bold: true
    }, "Patient subtotal"), /*#__PURE__*/ _react.default.createElement(P, null, (0, _invoice.formatDisplayPrice)(patientSubtotal))), /*#__PURE__*/ _react.default.createElement(HorizontalRule, null), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: summaryPaneStyles.item
    }, /*#__PURE__*/ _react.default.createElement(P, null, "Patient payments"), /*#__PURE__*/ _react.default.createElement(P, null, (0, _invoice.formatDisplayPrice)(patientPaymentsTotalDisplay))), /*#__PURE__*/ _react.default.createElement(HorizontalRule, null), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: [
            summaryPaneStyles.item,
            {
                marginVertical: 7.5
            }
        ]
    }, /*#__PURE__*/ _react.default.createElement(P, {
        bold: true
    }, "Patient total due"), /*#__PURE__*/ _react.default.createElement(P, {
        bold: true
    }, (0, _invoice.formatDisplayPrice)(patientPaymentRemainingBalance))));
};
const InvoiceRecordPrintoutComponent = ({ patientData, encounter, certificateData, discharge, getLocalisation, getSetting, clinicianText, invoice, enablePatientInsurer })=>{
    const { watermark, logo, footerImg } = certificateData;
    const patientPayments = (0, _invoice.getPatientPaymentsWithRemainingBalanceDisplay)(invoice);
    const insurerPayments = (0, _invoice.getInsurerPaymentsWithRemainingBalanceDisplay)(invoice);
    return /*#__PURE__*/ _react.default.createElement(_renderer.Document, null, /*#__PURE__*/ _react.default.createElement(_Page.Page, {
        size: "A4",
        style: pageStyles.body,
        wrap: true
    }, watermark && /*#__PURE__*/ _react.default.createElement(_Layout.Watermark, {
        src: watermark
    }), /*#__PURE__*/ _react.default.createElement(_MultiPageHeader.MultiPageHeader, {
        documentName: `Invoice number: ${invoice.displayId}`,
        patientId: patientData.displayId,
        patientName: (0, _patientAccessors.getName)(patientData)
    }), /*#__PURE__*/ _react.default.createElement(_Layout.CertificateHeader, null, /*#__PURE__*/ _react.default.createElement(_LetterheadSection.LetterheadSection, {
        logoSrc: logo,
        certificateTitle: `Invoice number: ${invoice.displayId}`,
        letterheadConfig: certificateData
    })), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), /*#__PURE__*/ _react.default.createElement(_PatientDetails.PatientDetails, {
        getLocalisation: getLocalisation,
        getSetting: getSetting,
        patient: patientData
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), /*#__PURE__*/ _react.default.createElement(_InvoiceEncounterDetails.InvoiceEncounterDetails, {
        encounter: encounter,
        discharge: discharge,
        clinicianText: clinicianText
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), /*#__PURE__*/ _react.default.createElement(_InvoiceDetails.InvoiceDetails, {
        encounter: encounter,
        invoice: invoice,
        patient: patientData,
        enablePatientInsurer: enablePatientInsurer
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), invoice?.items?.length > 0 && /*#__PURE__*/ _react.default.createElement(InvoiceItemTableSection, {
        data: invoice?.items,
        columns: COLUMNS.invoiceItems,
        showAdjustmentRows: true
    }), /*#__PURE__*/ _react.default.createElement(SummaryPane, {
        invoice: invoice
    }), /*#__PURE__*/ _react.default.createElement(SectionSpacing, null), patientPayments?.length && /*#__PURE__*/ _react.default.createElement(PaymentTableSection, {
        title: "Patient payment",
        data: patientPayments,
        columns: COLUMNS.patientPayments
    }), insurerPayments?.length && /*#__PURE__*/ _react.default.createElement(PaymentTableSection, {
        title: "Insurer payment",
        data: insurerPayments,
        columns: COLUMNS.insurerPayments
    }), footerImg && /*#__PURE__*/ _react.default.createElement(_Layout.SigningImage, {
        src: footerImg
    }), /*#__PURE__*/ _react.default.createElement(_Footer.Footer, null)));
};
const InvoiceRecordPrintout = (0, _languageContext.withLanguageContext)(InvoiceRecordPrintoutComponent);

//# sourceMappingURL=InvoiceRecordPrintout.js.map