"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "SigningSection", {
    enumerable: true,
    get: function() {
        return SigningSection;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _Layout = require("./Layout");
const _languageContext = require("../pdf/languageContext");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const SigningSection = ({ signingSrc, style, ...props })=>{
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    return /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            flexDirection: 'column',
            justifyContent: 'flex-end',
            flex: 1,
            paddingLeft: 15,
            paddingRight: 15,
            ...style
        },
        ...props
    }, signingSrc ? /*#__PURE__*/ _react.default.createElement(_Layout.SigningImage, {
        src: signingSrc
    }) : /*#__PURE__*/ _react.default.createElement(_Layout.Box, {
        mb: 0
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Box, null, /*#__PURE__*/ _react.default.createElement(_Layout.Signature, {
        text: getTranslation('pdf.signature.authorisedBy', 'Authorised by')
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Box, {
        mb: 10
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Signature, {
        text: getTranslation('pdf.signature.signed', 'Signed')
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Box, null, /*#__PURE__*/ _react.default.createElement(_Layout.Signature, {
        text: getTranslation('pdf.signature.date', 'Date')
    }))));
};

//# sourceMappingURL=SigningSection.js.map