"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "InvoiceEncounterDetails", {
    enumerable: true,
    get: function() {
        return InvoiceEncounterDetails;
    }
});
const _react = /*#__PURE__*/ _interop_require_default(require("react"));
const _renderer = require("@react-pdf/renderer");
const _constants = require("@tamanu/constants");
const _DataSection = require("./DataSection");
const _DataItem = require("./DataItem");
const _patientAccessors = require("../../patientAccessors");
const _Layout = require("../Layout");
const _HorizontalRule = require("./HorizontalRule");
const _languageContext = require("../../pdf/languageContext");
const _dateTime = require("@tamanu/utils/dateTime");
const _Typography = require("../Typography");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const InvoiceEncounterDetails = ({ encounter })=>{
    const { location, department, startDate, endDate, diagnoses } = encounter || {};
    const { getTranslation } = (0, _languageContext.useLanguageContext)();
    const filterAndSortDiagnoses = (isPrimary)=>diagnoses.filter((diagnosis)=>diagnosis.isPrimary === isPrimary).filter(({ certainty })=>certainty === _constants.DIAGNOSIS_CERTAINTY.CONFIRMED).sort((a, b)=>a.diagnosis.name.localeCompare(b.diagnosis.name));
    const primaryDiagnoses = filterAndSortDiagnoses(true);
    const secondaryDiagnoses = filterAndSortDiagnoses(false);
    return /*#__PURE__*/ _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/ _react.default.createElement(_DataSection.DataSection, {
        title: getTranslation('pdf.encounterDetails.title', 'Encounter details'),
        hideBottomRule: true
    }, /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.localisedField.facility.label', 'Facility'),
        value: location?.facility?.name
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('encounter.admissionDate.label', 'Admission date'),
        value: (0, _dateTime.formatShort)(startDate)
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('encounter.dischargeDate.label', 'Discharge date'),
        value: (0, _dateTime.formatShort)(endDate)
    })), /*#__PURE__*/ _react.default.createElement(_Layout.Col, null, /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.department.label', 'Department'),
        value: department?.name
    }), /*#__PURE__*/ _react.default.createElement(_DataItem.DataItem, {
        label: getTranslation('general.localisedField.location.label', 'Location'),
        value: (0, _patientAccessors.getLocationName)(encounter)
    }))), !!diagnoses?.length && /*#__PURE__*/ _react.default.createElement(_HorizontalRule.HorizontalRule, {
        width: "1px"
    }), !!primaryDiagnoses?.length && /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        style: {
            marginVertical: 3,
            marginRight: 12.5
        },
        bold: true,
        fontSize: 9
    }, getTranslation('encounter.primaryDiagnoses.label', 'Primary diagnoses'), ":", ' '), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            marginVertical: 3
        }
    }, primaryDiagnoses.map((diagnosis)=>/*#__PURE__*/ _react.default.createElement(_Typography.P, {
            key: diagnosis.id,
            style: {
                marginVertical: 0
            },
            fontSize: 9
        }, diagnosis.diagnosis.name)))), !!secondaryDiagnoses?.length && /*#__PURE__*/ _react.default.createElement(_Layout.Row, null, /*#__PURE__*/ _react.default.createElement(_Typography.P, {
        style: {
            marginVertical: 3
        },
        bold: true,
        fontSize: 9
    }, getTranslation('encounter.secondaryDiagnoses.label', 'Secondary diagnoses'), ":", ' '), /*#__PURE__*/ _react.default.createElement(_renderer.View, {
        style: {
            marginVertical: 3
        }
    }, secondaryDiagnoses.map((diagnosis)=>/*#__PURE__*/ _react.default.createElement(_Typography.P, {
            key: diagnosis.id,
            style: {
                marginVertical: 0
            },
            fontSize: 9
        }, diagnosis.diagnosis.name)))), /*#__PURE__*/ _react.default.createElement(_HorizontalRule.HorizontalRule, {
        width: "2px"
    }));
};

//# sourceMappingURL=InvoiceEncounterDetails.js.map