"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    replaceStringVariables: function() {
        return replaceStringVariables;
    },
    translationFactory: function() {
        return translationFactory;
    }
});
const _lodash = require("lodash");
const applyCasing = (text, casing)=>{
    if (!casing) return text;
    if (casing === 'lower') return text.toLocaleLowerCase();
    if (casing === 'upper') return text.toLocaleUpperCase();
    if (casing === 'sentence') return (0, _lodash.upperFirst)(text);
    throw new Error(`applyCasing called with unhandled value: ${casing}`);
};
const replaceStringVariables = (templateString, { replacements, casing } = {}, translations)=>{
    if (!replacements) return applyCasing(templateString, casing);
    const result = templateString.split(/(:[a-zA-Z]+)/g).map((part, index)=>{
        // Even indexes are the unchanged parts of the string
        if (index % 2 === 0) return part;
        // Return the replacement if exists
        let replacement = replacements[part.slice(1)] ?? part;
        if (typeof replacement !== 'object') return replacement;
        const translation = translations?.[replacement.props.stringId] || replacement.props.fallback;
        return applyCasing(translation, replacement.props.casing);
    }).join('');
    return applyCasing(result, casing);
};
const translationFactory = (translations)=>(stringId, fallback, translationOptions)=>{
        if (!translations) return {
            value: replaceStringVariables(fallback, translationOptions, translations)
        };
        const translation = translations[stringId] ?? fallback;
        return {
            value: replaceStringVariables(translation, translationOptions, translations),
            notExisting: !translations[stringId]
        };
    };

//# sourceMappingURL=translationFactory.js.map