"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "generateEUDCCFormatUVCI", {
    enumerable: true,
    get: function() {
        return generateEUDCCFormatUVCI;
    }
});
const _calculateluhnmodn = /*#__PURE__*/ _interop_require_default(require("calculate-luhn-mod-n"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function generateEUDCCFormatUVCI(vaccinationId, countryCode) {
    // UVCI id is required to be uppercase alphanumeric
    // Use the uuid of the vaccination record, drop the dashes
    const id = vaccinationId.replace(/-/g, '').toUpperCase();
    const radix = 36; // 10 digits plus 26 uppercase letters
    const UVCI = `URN:UVCI:01:${countryCode}:${id}`;
    const checksum = (0, _calculateluhnmodn.default)((char)=>Number.parseInt(char, radix), (codePoint)=>codePoint.toString(radix).toUpperCase(), radix, id);
    return `${UVCI}#${checksum}`;
}

//# sourceMappingURL=eudcc.js.map