import { z } from 'zod';
export declare const AdministeredVaccineSchema: z.ZodObject<{
    id: z.ZodString;
    batch: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    status: z.ZodEnum<{
        UNKNOWN: string;
        GIVEN: string;
        NOT_GIVEN: string;
        SCHEDULED: string;
        MISSED: string;
        DUE: string;
        UPCOMING: string;
        OVERDUE: string;
        RECORDED_IN_ERROR: string;
        HISTORICAL: string;
    }>;
    date: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    location: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        code: z.ZodString;
        name: z.ZodString;
        facility: z.ZodObject<{
            id: z.ZodString;
            code: z.ZodString;
            name: z.ZodString;
        }, z.core.$strip>;
    }, z.core.$strip>>>;
    injectionSite: z.ZodOptional<z.ZodNullable<z.ZodEnum<{
        LEFT_ARM: string;
        RIGHT_ARM: string;
        LEFT_THIGH: string;
        RIGHT_THIGH: string;
        ORAL: string;
        OTHER: string;
    }>>>;
    vaccineBrand: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    vaccineName: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    disease: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    givenBy: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    givenElsewhere: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
    consent: z.ZodOptional<z.ZodNullable<z.ZodBoolean>>;
    consentGivenBy: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    reason: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    scheduledVaccine: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        category: z.ZodEnum<{
            [x: string]: string;
        }>;
        label: z.ZodString;
        doseLabel: z.ZodString;
        weeksFromBirthDue: z.ZodNullable<z.ZodNumber>;
        vaccine: z.ZodObject<{
            id: z.ZodString;
            name: z.ZodString;
            code: z.ZodString;
            type: z.ZodString;
        }, z.core.$strip>;
        visibilityStatus: z.ZodString;
    }, z.core.$strip>>>;
    recorder: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        displayName: z.ZodString;
    }, z.core.$strip>>>;
    notGivenReason: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        id: z.ZodString;
        name: z.ZodString;
        code: z.ZodString;
        type: z.ZodString;
    }, z.core.$strip>>>;
}, z.core.$strip>;
export type AdministeredVaccine = z.infer<typeof AdministeredVaccineSchema>;
//# sourceMappingURL=administeredVaccine.schema.d.ts.map