import React from 'react';
import { getDisplayDate } from '../patientCertificates/getDisplayDate';
import { Box, Logo } from '../patientCertificates/Layout';
import { H1, H3 } from '../patientCertificates/Typography';
import { Divider } from './Divider';
export const HandoverHeaderSection = ({ letterheadConfig, logoSrc, locationGroupName })=>{
    const { title, subTitle } = letterheadConfig;
    return /*#__PURE__*/ React.createElement(React.Fragment, null, logoSrc && /*#__PURE__*/ React.createElement(Logo, {
        logoSrc: logoSrc
    }), /*#__PURE__*/ React.createElement(Box, {
        style: {
            maxWidth: 400,
            marginLeft: 'auto',
            marginRight: '0',
            width: '100%'
        }
    }, /*#__PURE__*/ React.createElement(H3, {
        style: {
            textAlign: 'right',
            fontWeight: 700,
            marginBottom: 10
        }
    }, title), /*#__PURE__*/ React.createElement(H3, {
        style: {
            textAlign: 'right',
            fontWeight: 'bold'
        }
    }, subTitle), /*#__PURE__*/ React.createElement(H1, {
        style: {
            textAlign: 'right',
            fontSize: 18,
            marginBottom: 5,
            marginTop: 0
        }
    }, "Handover notes"), /*#__PURE__*/ React.createElement(H1, {
        style: {
            textAlign: 'right',
            fontSize: 17,
            marginTop: 0
        }
    }, locationGroupName, " | ", getDisplayDate(new Date(), 'dd/MM/yy hh:mm a'))), /*#__PURE__*/ React.createElement(Divider, null));
};

//# sourceMappingURL=HandoverHeaderSection.js.map