import React from 'react';
import { Document } from '@react-pdf/renderer';
import { Table } from './Table';
import { Box, Col, Row, styles, Watermark } from './Layout';
import { CovidPatientDetailsSection } from './CovidPatientDetailsSection';
import { SigningSection } from './SigningSection';
import { H3, P } from './Typography';
import { CovidLetterheadSection } from './CovidLetterheadSection';
import { getDisplayDate } from './getDisplayDate';
import { withLanguageContext } from '../pdf/languageContext';
import { Page } from '../pdf/Page';
const columns = [
    {
        key: 'vaccine',
        title: 'Vaccine',
        customStyles: {
            minWidth: 30
        },
        accessor: ({ scheduledVaccine })=>(scheduledVaccine || {}).label
    },
    {
        key: 'vaccineBrand',
        title: 'Vaccine brand',
        customStyles: {
            minWidth: 30
        },
        accessor: ({ scheduledVaccine })=>((scheduledVaccine || {}).vaccine || {}).name
    },
    {
        key: 'schedule',
        title: 'Schedule',
        accessor: ({ scheduledVaccine })=>(scheduledVaccine || {}).doseLabel
    },
    {
        key: 'countryName',
        title: 'Country',
        accessor: ({ countryName })=>countryName
    },
    {
        key: 'healthFacility',
        title: 'Health facility',
        customStyles: {
            minWidth: 30
        },
        accessor: ({ healthFacility })=>healthFacility
    },
    {
        key: 'date',
        title: 'Date',
        accessor: ({ date }, getLocalisation)=>date ? getDisplayDate(date, undefined, getLocalisation) : 'Unknown'
    },
    {
        key: 'batch',
        title: 'Batch number',
        accessor: ({ batch })=>batch
    }
];
const CovidVaccineCertificateComponent = ({ patient, printedBy, vaccinations, certificateId, signingSrc, watermarkSrc, vdsSrc, logoSrc, uvci, getLocalisation, getSetting, extraPatientFields, printedDate })=>{
    const { emailAddress: contactEmail, contactNumber, healthFacility } = getSetting('templates.vaccineCertificate');
    const countryName = getLocalisation('country.name');
    console.log('uvci', uvci);
    const data = vaccinations.map((vaccination)=>({
            ...vaccination,
            countryName,
            healthFacility
        }));
    return /*#__PURE__*/ React.createElement(Document, null, /*#__PURE__*/ React.createElement(Page, {
        size: "A4",
        style: styles.page
    }, watermarkSrc && /*#__PURE__*/ React.createElement(Watermark, {
        src: watermarkSrc
    }), /*#__PURE__*/ React.createElement(CovidLetterheadSection, {
        getSetting: getSetting,
        logoSrc: logoSrc
    }), /*#__PURE__*/ React.createElement(H3, null, "COVID-19 Vaccine Certificate"), /*#__PURE__*/ React.createElement(CovidPatientDetailsSection, {
        patient: patient,
        vdsSrc: vdsSrc,
        getLocalisation: getLocalisation,
        getSetting: getSetting,
        certificateId: certificateId,
        extraFields: extraPatientFields,
        uvci: uvci
    }), /*#__PURE__*/ React.createElement(Box, {
        mb: 20
    }, /*#__PURE__*/ React.createElement(Table, {
        data: data,
        columns: columns,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })), /*#__PURE__*/ React.createElement(Box, null, /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(P, null, "Printed by: ", printedBy)), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(P, null, "Printing date: ", getDisplayDate(printedDate))))), /*#__PURE__*/ React.createElement(SigningSection, {
        signingSrc: signingSrc
    }), /*#__PURE__*/ React.createElement(Box, null, contactEmail ? /*#__PURE__*/ React.createElement(P, null, "Email address: ", contactEmail) : null, contactNumber ? /*#__PURE__*/ React.createElement(P, null, "Contact number: ", contactNumber) : null)));
};
export const CovidVaccineCertificate = withLanguageContext(CovidVaccineCertificateComponent);

//# sourceMappingURL=CovidVaccineCertificate.js.map