import { Document, StyleSheet, Text, View } from '@react-pdf/renderer';
import React from 'react';
import { DRUG_ROUTE_LABELS } from '@tamanu/constants';
import { CertificateContent, CertificateHeader, Col, Signature, styles } from './Layout';
import { PatientDetailsWithBarcode } from './printComponents/PatientDetailsWithBarcode';
import { Table } from './Table';
import { DataSection } from './printComponents/DataSection';
import { DataItem } from './printComponents/DataItem';
import { getDisplayDate } from './getDisplayDate';
import { getCurrentDateString } from '@tamanu/utils/dateTime';
import { LetterheadSection } from './LetterheadSection';
import { useLanguageContext, withLanguageContext } from '../pdf/languageContext';
import { Page } from '../pdf/Page';
import { getMedicationDoseDisplay, getTranslatedFrequency } from '../medication';
import { Footer } from './printComponents/Footer';
const columns = (getTranslation, getEnumTranslation)=>[
        {
            key: 'medication',
            title: getTranslation('pdf.table.column.medication', 'Medication'),
            accessor: ({ medication, notes, indication })=>/*#__PURE__*/ React.createElement(View, null, /*#__PURE__*/ React.createElement(Text, null, medication?.name + `\n`), notes && /*#__PURE__*/ React.createElement(Text, {
                    style: {
                        fontFamily: 'Helvetica-Oblique'
                    }
                }, notes + `\n`), indication && /*#__PURE__*/ React.createElement(Text, null, /*#__PURE__*/ React.createElement(Text, {
                    style: {
                        fontFamily: 'Helvetica-Bold'
                    }
                }, getTranslation('medication.indication.label', 'Indication'), ":"), /*#__PURE__*/ React.createElement(Text, null, ` ${indication}`))),
            customStyles: {
                minWidth: 180
            }
        },
        {
            key: 'dose',
            title: getTranslation('pdf.table.column.dose', 'Dose'),
            accessor: (medication)=>{
                return /*#__PURE__*/ React.createElement(Text, null, getMedicationDoseDisplay(medication, getTranslation, getEnumTranslation), medication?.isPrn && ` ${getTranslation('medication.table.prn', 'PRN')}`);
            }
        },
        {
            key: 'frequency',
            title: getTranslation('pdf.table.column.frequency', 'Frequency'),
            accessor: ({ frequency })=>getTranslatedFrequency(frequency, getTranslation),
            customStyles: {
                minWidth: 30
            }
        },
        {
            key: 'route',
            title: getTranslation('pdf.table.column.route', 'Route'),
            accessor: ({ route })=>getEnumTranslation(DRUG_ROUTE_LABELS, route)
        },
        {
            key: 'quantity',
            title: getTranslation('pdf.table.column.quantity', 'Quantity'),
            accessor: ({ quantity })=>quantity
        },
        {
            key: 'repeats',
            title: getTranslation('pdf.table.column.repeats', 'Repeats'),
            accessor: ({ repeats })=>repeats
        }
    ];
const prescriptionSectionStyles = StyleSheet.create({
    tableContainer: {
        marginTop: 12
    }
});
const signingSectionStyles = StyleSheet.create({
    container: {
        marginTop: 22
    }
});
const generalStyles = StyleSheet.create({
    container: {
        marginVertical: 8
    }
});
const SectionContainer = (props)=>/*#__PURE__*/ React.createElement(View, {
        style: generalStyles.container,
        ...props
    });
const PrescriptionsSection = ({ prescriptions, prescriber, facility, getLocalisation, getSetting })=>{
    const { getTranslation, getEnumTranslation } = useLanguageContext();
    return /*#__PURE__*/ React.createElement(View, null, /*#__PURE__*/ React.createElement(DataSection, {
        hideBottomRule: true,
        title: "Prescription details"
    }, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: "Date",
        value: getDisplayDate(getCurrentDateString())
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: "Prescriber",
        value: prescriber?.displayName
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: "Prescriber ID",
        value: prescriber?.displayId ?? 'n/a'
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: "Facility",
        value: facility?.name
    }))), /*#__PURE__*/ React.createElement(View, {
        style: prescriptionSectionStyles.tableContainer
    }, /*#__PURE__*/ React.createElement(Table, {
        columns: columns(getTranslation, getEnumTranslation),
        data: prescriptions,
        getLocalisation: getLocalisation,
        getSetting: getSetting,
        columnStyle: {
            padding: '8px 7px'
        }
    })));
};
const PrescriptionSigningSection = ()=>/*#__PURE__*/ React.createElement(View, {
        style: signingSectionStyles.container
    }, /*#__PURE__*/ React.createElement(Signature, {
        fontSize: 9,
        lineThickness: 0.5,
        text: "Signed"
    }), /*#__PURE__*/ React.createElement(Signature, {
        fontSize: 9,
        lineThickness: 0.5,
        text: "Date"
    }));
const PrescriptionPrintoutComponent = ({ patientData, prescriptions, prescriber, certificateData, facility, getLocalisation, getSetting })=>{
    return /*#__PURE__*/ React.createElement(Document, null, /*#__PURE__*/ React.createElement(Page, {
        size: "A4",
        style: [
            styles.page,
            {
                paddingBottom: '50'
            }
        ]
    }, /*#__PURE__*/ React.createElement(CertificateHeader, null, /*#__PURE__*/ React.createElement(LetterheadSection, {
        letterheadConfig: certificateData,
        logoSrc: certificateData.logo,
        certificateTitle: "Prescription"
    }), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(PatientDetailsWithBarcode, {
        patient: patientData,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    }))), /*#__PURE__*/ React.createElement(CertificateContent, {
        style: {
            margin: 0
        }
    }, /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(PrescriptionsSection, {
        prescriptions: prescriptions,
        prescriber: prescriber,
        facility: facility,
        getLocalisation: getLocalisation,
        getSetting: getSetting
    })), /*#__PURE__*/ React.createElement(SectionContainer, null, /*#__PURE__*/ React.createElement(PrescriptionSigningSection, null))), /*#__PURE__*/ React.createElement(Footer, {
        style: {
            left: 30,
            right: 30
        }
    })));
};
export const PrescriptionPrintout = withLanguageContext(PrescriptionPrintoutComponent);

//# sourceMappingURL=PrescriptionPrintout.js.map