import React from 'react';
import { DataSection } from './DataSection';
import { DataItem } from './DataItem';
import { getLocationName } from '../../patientAccessors';
import { Col } from '../Layout';
import { HorizontalRule } from './HorizontalRule';
import { useLanguageContext } from '../../pdf/languageContext';
export const EncounterDetails = ({ encounter, hideLocation = false })=>{
    const { getTranslation } = useLanguageContext();
    const { location, department } = encounter || {};
    return /*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(DataSection, {
        title: getTranslation('pdf.encounterDetails.title', 'Encounter details'),
        hideBottomRule: true
    }, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.localisedField.facility.label', 'Facility'),
        value: location?.facility?.name
    }), !hideLocation && /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.localisedField.locationId.label', 'Location'),
        value: getLocationName(encounter)
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.department.label', 'Department'),
        value: department?.name
    }))), /*#__PURE__*/ React.createElement(HorizontalRule, {
        width: "2px"
    }));
};

//# sourceMappingURL=EncounterDetails.js.map