import React from 'react';
import { View } from '@react-pdf/renderer';
import { DIAGNOSIS_CERTAINTY } from '@tamanu/constants';
import { DataSection } from './DataSection';
import { DataItem } from './DataItem';
import { getLocationName } from '../../patientAccessors';
import { Col, Row } from '../Layout';
import { HorizontalRule } from './HorizontalRule';
import { useLanguageContext } from '../../pdf/languageContext';
import { formatShort } from '@tamanu/utils/dateTime';
import { P } from '../Typography';
export const InvoiceEncounterDetails = ({ encounter })=>{
    const { location, department, startDate, endDate, diagnoses } = encounter || {};
    const { getTranslation } = useLanguageContext();
    const filterAndSortDiagnoses = (isPrimary)=>diagnoses.filter((diagnosis)=>diagnosis.isPrimary === isPrimary).filter(({ certainty })=>certainty === DIAGNOSIS_CERTAINTY.CONFIRMED).sort((a, b)=>a.diagnosis.name.localeCompare(b.diagnosis.name));
    const primaryDiagnoses = filterAndSortDiagnoses(true);
    const secondaryDiagnoses = filterAndSortDiagnoses(false);
    return /*#__PURE__*/ React.createElement(React.Fragment, null, /*#__PURE__*/ React.createElement(DataSection, {
        title: getTranslation('pdf.encounterDetails.title', 'Encounter details'),
        hideBottomRule: true
    }, /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.localisedField.facility.label', 'Facility'),
        value: location?.facility?.name
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('encounter.admissionDate.label', 'Admission date'),
        value: formatShort(startDate)
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('encounter.dischargeDate.label', 'Discharge date'),
        value: formatShort(endDate)
    })), /*#__PURE__*/ React.createElement(Col, null, /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.department.label', 'Department'),
        value: department?.name
    }), /*#__PURE__*/ React.createElement(DataItem, {
        label: getTranslation('general.localisedField.location.label', 'Location'),
        value: getLocationName(encounter)
    }))), !!diagnoses?.length && /*#__PURE__*/ React.createElement(HorizontalRule, {
        width: "1px"
    }), !!primaryDiagnoses?.length && /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(P, {
        style: {
            marginVertical: 3,
            marginRight: 12.5
        },
        bold: true,
        fontSize: 9
    }, getTranslation('encounter.primaryDiagnoses.label', 'Primary diagnoses'), ":", ' '), /*#__PURE__*/ React.createElement(View, {
        style: {
            marginVertical: 3
        }
    }, primaryDiagnoses.map((diagnosis)=>/*#__PURE__*/ React.createElement(P, {
            key: diagnosis.id,
            style: {
                marginVertical: 0
            },
            fontSize: 9
        }, diagnosis.diagnosis.name)))), !!secondaryDiagnoses?.length && /*#__PURE__*/ React.createElement(Row, null, /*#__PURE__*/ React.createElement(P, {
        style: {
            marginVertical: 3
        },
        bold: true,
        fontSize: 9
    }, getTranslation('encounter.secondaryDiagnoses.label', 'Secondary diagnoses'), ":", ' '), /*#__PURE__*/ React.createElement(View, {
        style: {
            marginVertical: 3
        }
    }, secondaryDiagnoses.map((diagnosis)=>/*#__PURE__*/ React.createElement(P, {
            key: diagnosis.id,
            style: {
                marginVertical: 0
            },
            fontSize: 9
        }, diagnosis.diagnosis.name)))), /*#__PURE__*/ React.createElement(HorizontalRule, {
        width: "2px"
    }));
};

//# sourceMappingURL=InvoiceEncounterDetails.js.map