import type { MigrationStr, Step, StepStr } from './step.ts';
export declare const MIGRATIONS_START: string;
export declare const MIGRATIONS_END: string;
export interface ResolvedStep {
    id: StepStr;
    file: string;
    step: Required<Step>;
}
export declare function listSteps(): Promise<{
    order: StepStr[];
    steps: Map<`upgrade/${string}/${number}`, ResolvedStep>;
}>;
/** @internal exported only for testing purposes, use listSteps instead */
export declare function orderSteps(steps: ResolvedStep[], migrations: MigrationStr[]): Promise<{
    order: StepStr[];
    steps: Map<`upgrade/${string}/${number}`, ResolvedStep>;
}>;
//# sourceMappingURL=listSteps.d.ts.map