"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    adjustDateForFrequency: function() {
        return adjustDateForFrequency;
    },
    eachWeekdayInMonth: function() {
        return eachWeekdayInMonth;
    },
    generateFrequencyDates: function() {
        return generateFrequencyDates;
    },
    getLastFrequencyDate: function() {
        return getLastFrequencyDate;
    },
    getNextFrequencyDate: function() {
        return getNextFrequencyDate;
    },
    getWeekdayOrdinalPosition: function() {
        return getWeekdayOrdinalPosition;
    },
    weekdayAtOrdinalPosition: function() {
        return weekdayAtOrdinalPosition;
    }
});
const _constants = require("@tamanu/constants");
const _datefns = require("date-fns");
const _dateTime = require("./dateTime");
const eachWeekdayInMonth = (date, weekday = date.getDay())=>(0, _dateTime.eachDayInMonth)(date).filter((day)=>day.getDay() === weekday);
const weekdayAtOrdinalPosition = (date, day, nth)=>{
    const matchingWeekdays = eachWeekdayInMonth(date, _constants.DAYS_OF_WEEK.indexOf(day));
    // Convert ordinal positioning to 0-based index but leave -1 as last occurrence
    const atIndex = Math.max(nth - 1, -1);
    const matchingWeekday = matchingWeekdays.at(atIndex);
    if (!matchingWeekday) {
        throw new Error('No weekday found at the specified ordinal position');
    }
    return matchingWeekday;
};
const getWeekdayOrdinalPosition = (date)=>{
    const matchingWeekdays = eachWeekdayInMonth(date);
    // Ordinal positioning is 1-based, -1 means the date is the last occurrence of the weekday in the month
    const nthWeekday = matchingWeekdays.findIndex((day)=>(0, _datefns.isSameDay)(day, date)) + 1;
    return nthWeekday === matchingWeekdays.length ? -1 : nthWeekday;
};
const adjustDateForFrequency = (date, repeatUnit, dayOfWeek, nthWeekday)=>{
    if (repeatUnit === _constants.REPEAT_FREQUENCY.MONTHLY) {
        return (0, _datefns.set)(date, {
            date: weekdayAtOrdinalPosition(date, dayOfWeek, nthWeekday).getDate()
        });
    }
    return date;
};
const getNextFrequencyDate = (date, repeatFrequency, repeatUnit)=>{
    const dayOfWeek = (0, _datefns.format)((0, _datefns.parseISO)(date), 'iiiiii').toUpperCase();
    const nthWeekday = getWeekdayOrdinalPosition(new Date(date));
    const incrementedDate = (0, _datefns.add)((0, _datefns.parseISO)(date), {
        [_constants.REPEAT_FREQUENCY_UNIT_PLURAL_LABELS[repeatUnit]]: repeatFrequency
    });
    return (0, _dateTime.toDateString)(adjustDateForFrequency(incrementedDate, repeatUnit, dayOfWeek, nthWeekday));
};
const generateFrequencyDates = (startDate, endDate, repeatFrequency, repeatUnit)=>{
    if (!startDate || !endDate) {
        return [];
    }
    let nextDate = startDate;
    const frequencyDates = [];
    while(nextDate <= endDate){
        frequencyDates.push(nextDate);
        nextDate = getNextFrequencyDate(frequencyDates.at(-1), repeatFrequency, repeatUnit);
    }
    return frequencyDates;
};
const getLastFrequencyDate = (startDate, repeatFrequency, repeatUnit, occurrence)=>{
    if (!startDate || occurrence < 1) {
        return null;
    }
    let currentDate = startDate;
    for(let i = 1; i < occurrence; i++){
        currentDate = getNextFrequencyDate(currentDate, repeatFrequency, repeatUnit);
    }
    return currentDate;
};

//# sourceMappingURL=appointmentScheduling.js.map