export declare const isGeneratedDisplayId: (displayId: string) => boolean;
/**
 * Generates an ID from a pattern.
 * A will be replaced with a random letter and 0 will be replaced with a random number.
 * Wrapping characters in [] will allow static characters to be used.
 * @param pattern - The pattern to use for generating the ID.
 * @returns The generated ID.
 * @example
 * generateIdFromPattern('AAAA000000') // 'GHIJ675432'
 * generateIdFromPattern('[B]000000') // 'B675432'
 * generateIdFromPattern('[B]AA[A]000') // 'BGHA675'
 */
export declare const generateIdFromPattern: (pattern: string) => string;
export declare const generateId: () => string;
/**
 * Validates if a display ID matches a given pattern.
 * @param displayId - The display ID to validate.
 * @param pattern - The pattern to use for validating the display ID.
 * @returns True if the display ID matches the pattern, false otherwise.
 * @example
 * isGeneratedIdFromPattern('GHIJ675432', 'AAAA000000') // true
 * isGeneratedIdFromPattern('BCDEFA123', '[BC]AA[A]000') // true
 * isGeneratedIdFromPattern('B350031', '[B]AA[A]000') // false
 */
export declare const isGeneratedIdFromPattern: (displayId: string, pattern: string) => boolean;
/**
 * Makes a 'fake' but valid uuid like '2964ea0d-073d-0000-bda1-ce47fd5de340'.
 *
 * This is built from a UUID v4, but replacing this particular segment means
 * we're also replacing the V4 indication, making this a "version zero" UUID,
 * which doesn't exist and thus cannot conflict with "naturally generated" ones.
 * Yet it will fit in 128-bit binary representation types and also in 36-bytes
 * (or variable width) text representations types.
 *
 * This is used to run tests against real data, where we're able to clear out
 * everything that was created by the tests with just a simple query. See the
 * accompanying FAKE_UUID_PATTERN constant for the SQL LIKE pattern to use.
 */
export declare const fakeUUID: () => string;
export declare const FAKE_UUID_PATTERN = "________-____-0000-____-____________";
//# sourceMappingURL=generateId.d.ts.map