"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/json.js
var json_exports = {};
__export(json_exports, {
  InvalidJsonInKdlError: () => InvalidJsonInKdlError,
  fromJson: () => fromJson,
  parse: () => parse,
  stringify: () => stringify,
  toJson: () => toJson
});
module.exports = __toCommonJS(json_exports);
var import_kdl = require("@bgotink/kdl");
var arrayItemKey = "-";
var InvalidJsonInKdlError = class extends Error {
  constructor(message) {
    super(message);
    this.name = "InvalidJsonInKdlError";
  }
};
function nodeToJsonValue(node, { ignoreValues = false, type = node.getTag() ?? void 0, reviver } = {}) {
  var _a, _b;
  const args = ignoreValues ? [] : node.getArgumentEntries();
  const props = new Map(
    node.getPropertyEntries().map((node2) => [node2.getName(), node2])
  );
  if (type === "object" || type !== "array" && (props.size > 0 || ((_a = node.children) == null ? void 0 : _a.nodes.some((child) => child.getName() !== arrayItemKey)))) {
    if (args.length > 0) {
      throw new InvalidJsonInKdlError("A JSON object cannot have arguments");
    }
    const properties = /* @__PURE__ */ new Map();
    for (const [name, prop] of props) {
      let property = prop.getValue();
      if (reviver != null) {
        property = reviver(property, name, { location: prop });
        if (property === void 0) {
          continue;
        }
      }
      properties.set(name, property);
    }
    if (node.children) {
      for (const child of node.children.nodes) {
        const name = child.getName();
        if (properties.has(name)) {
          throw new InvalidJsonInKdlError(
            `Duplicate key ${JSON.stringify(name)} in JSON object`
          );
        }
        let property = nodeToJsonValue(child, { reviver });
        if (reviver != null) {
          property = reviver(property, name, { location: child });
          if (property === void 0) {
            continue;
          }
        }
        properties.set(name, property);
      }
    }
    return Object.fromEntries(properties);
  }
  if (type === "array" || args.length > 1 || node.hasChildren()) {
    if (props.size > 0 || ((_b = node.children) == null ? void 0 : _b.nodes.some((child) => child.getName() !== arrayItemKey))) {
      throw new InvalidJsonInKdlError(
        "A JSON array cannot have properties or named children"
      );
    }
    const values = [];
    let index = 0;
    for (const arg of args) {
      let value = arg.getValue();
      if (reviver != null) {
        value = reviver(value, index, { location: arg });
        index++;
        if (value === void 0) {
          continue;
        }
      }
      values.push(value);
    }
    if (node.children) {
      for (const child of node.children.nodes) {
        let value = nodeToJsonValue(child, { reviver });
        if (reviver != null) {
          value = reviver(value, index, { location: child });
          index++;
          if (value === void 0) {
            continue;
          }
        }
        values.push(value);
      }
    }
    return values;
  }
  if (args.length === 0) {
    throw new InvalidJsonInKdlError(
      `No value found in node ${JSON.stringify(node.getName())}`
    );
  }
  return args[0].getValue();
}
function toJson(nodeOrDocument, options) {
  let node;
  if (nodeOrDocument.type === "node") {
    node = nodeOrDocument;
  } else {
    if (nodeOrDocument.nodes.length !== 1) {
      throw new InvalidJsonInKdlError(
        "JSON-in-KDL requires a single node in the document"
      );
    }
    node = nodeOrDocument.nodes[0];
  }
  const value = nodeToJsonValue(node, options);
  if ((options == null ? void 0 : options.reviver) != null) {
    return options.reviver(value, "", { location: node });
  }
  return nodeToJsonValue(node, options);
}
function fromJson(value, {
  nodeName = arrayItemKey,
  allowEntries = true,
  allowEntriesInArrays = allowEntries,
  allowEntriesInObjects = allowEntries,
  allowEntriesInRoot,
  indentation: indentationStep
} = {}) {
  if (typeof indentationStep === "string") {
    indentationStep = indentationStep;
  } else if (typeof indentationStep === "number" && indentationStep > 0) {
    indentationStep = " ".repeat(indentationStep);
  } else {
    indentationStep = "";
  }
  const result = fromJsonValue(
    value,
    {
      nodeName,
      allowEntriesInArrays,
      allowEntriesInObjects,
      allowEntriesInCurrent: allowEntriesInRoot,
      indentation: "",
      indentationStep
    },
    /* @__PURE__ */ new Set()
  );
  if (!indentationStep) {
    result.trailing = "";
  }
  return result;
}
function isLiteral(value) {
  switch (typeof value) {
    case "boolean":
    case "number":
    case "string":
    case "undefined":
      return true;
    case "object":
      return value == null;
    default:
      return false;
  }
}
function fromJsonValue(value, {
  nodeName,
  indentation,
  indentationStep,
  allowEntriesInArrays,
  allowEntriesInObjects,
  allowEntriesInCurrent
}, parents) {
  if (value != null && typeof value === "object" && typeof value.toJSON === "function") {
    value = value.toJSON();
  }
  const node = import_kdl.Node.create(nodeName);
  node.leading = indentation;
  node.trailing = indentationStep ? "\n" : ";";
  if (isLiteral(value)) {
    node.addArgument(value ?? null);
    return node;
  }
  if (parents.has(value)) {
    throw new InvalidJsonInKdlError(
      `Cyclic JSON cannot be transformed into KDL`
    );
  }
  parents.add(value);
  try {
    if (Array.isArray(value)) {
      let useChild = !(allowEntriesInCurrent ?? allowEntriesInArrays);
      if (value.length === 0) {
        node.setTag("array");
      } else if (!useChild && value.length === 1 && isLiteral(value[0])) {
        node.setTag("array");
        node.addArgument(value[0] ?? null);
      } else {
        for (const item of value) {
          if (!useChild && isLiteral(item)) {
            node.addArgument(item ?? null);
          } else {
            useChild = true;
            node.appendNode(
              fromJsonValue(
                item,
                {
                  nodeName: arrayItemKey,
                  allowEntriesInArrays,
                  allowEntriesInObjects,
                  indentation: indentation + indentationStep,
                  indentationStep
                },
                parents
              )
            );
          }
        }
      }
    } else {
      const useChild = !(allowEntriesInCurrent ?? allowEntriesInObjects);
      const properties = Object.entries(
        value
      );
      if (properties.length === 0) {
        node.setTag("object");
      } else if (properties.length === 1 && properties[0][0] === arrayItemKey && (useChild || !isLiteral(properties[0][1]))) {
        node.setTag("object");
        node.appendNode(
          fromJsonValue(
            properties[0][1],
            {
              nodeName: arrayItemKey,
              allowEntriesInArrays,
              allowEntriesInObjects,
              indentation: indentation + indentationStep,
              indentationStep
            },
            parents
          )
        );
      } else {
        for (const [name, property] of properties) {
          if (!useChild && isLiteral(property)) {
            node.setProperty(name, property ?? null);
          } else {
            node.appendNode(
              fromJsonValue(
                property,
                {
                  nodeName: name,
                  allowEntriesInArrays,
                  allowEntriesInObjects,
                  indentation: indentation + indentationStep,
                  indentationStep
                },
                parents
              )
            );
          }
        }
      }
    }
    if (node.children) {
      if (indentationStep) {
        node.children.nodes[0].leading = `
${node.children.nodes[0].leading ?? ""}`;
      }
      node.children.trailing = indentation;
    }
    return node;
  } finally {
    parents.delete(value);
  }
}
function parse(string, reviver) {
  return toJson((0, import_kdl.parse)(string), { reviver });
}
function stringify(value, _, indentation) {
  return (0, import_kdl.format)(fromJson(value, { indentation }));
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  InvalidJsonInKdlError,
  fromJson,
  parse,
  stringify,
  toJson
});
