import { Adapter, BroadcastOptions, Room } from "socket.io-adapter";
import { Pool } from "pg";
export interface PostgresAdapterOptions {
    /**
     * the name of this node
     * @default a random id
     */
    uid: string;
    /**
     * The prefix of the notification channel
     * @default "socket.io"
     */
    channelPrefix: string;
    /**
     * The name of the table for payloads over the 8000 bytes limit or containing binary data
     * @default "socket_io_attachments"
     */
    tableName: string;
    /**
     * The threshold for the payload size in bytes (see https://www.postgresql.org/docs/current/sql-notify.html)
     * @default 8000
     */
    payloadThreshold: number;
    /**
     * after this timeout the adapter will stop waiting from responses to request
     * @default 5000
     */
    requestsTimeout: number;
    /**
     * Number of ms between two heartbeats
     * @default 5000
     */
    heartbeatInterval: number;
    /**
     * Number of ms without heartbeat before we consider a node down
     * @default 10000
     */
    heartbeatTimeout: number;
    /**
     * Number of ms between two cleanup queries
     * @default 30000
     */
    cleanupInterval: number;
    /**
     * Handler for errors. If undefined, the errors will be simply logged.
     *
     * @default undefined
     */
    errorHandler: (err: Error) => void;
}
/**
 * Returns a function that will create a PostgresAdapter instance.
 *
 * @param pool - a pg.Pool instance
 * @param opts - additional options
 *
 * @public
 */
export declare function createAdapter(pool: Pool, opts?: Partial<PostgresAdapterOptions>): (nsp: any) => PostgresAdapter;
export declare class PostgresAdapter extends Adapter {
    readonly uid: string;
    readonly channel: string;
    readonly tableName: string;
    requestsTimeout: number;
    heartbeatInterval: number;
    heartbeatTimeout: number;
    payloadThreshold: number;
    errorHandler: (err: Error) => void;
    private readonly pool;
    private nodesMap;
    private heartbeatTimer;
    private requests;
    private ackRequests;
    /**
     * Adapter constructor.
     *
     * @param nsp - the namespace
     * @param pool - a pg.Pool instance
     * @param opts - additional options
     *
     * @public
     */
    constructor(nsp: any, pool: Pool, opts?: Partial<PostgresAdapterOptions>);
    close(): Promise<void> | void;
    onEvent(event: any): Promise<any>;
    private scheduleHeartbeat;
    private publish;
    private publishWithAttachment;
    /**
     * Transform ES6 Set into plain arrays
     */
    private static serializeOptions;
    private static deserializeOptions;
    broadcast(packet: any, opts: BroadcastOptions): void;
    broadcastWithAck(packet: any, opts: BroadcastOptions, clientCountCallback: (clientCount: number) => void, ack: (...args: any[]) => void): void;
    serverCount(): Promise<number>;
    addSockets(opts: BroadcastOptions, rooms: Room[]): void;
    delSockets(opts: BroadcastOptions, rooms: Room[]): void;
    disconnectSockets(opts: BroadcastOptions, close: boolean): void;
    private getExpectedResponseCount;
    fetchSockets(opts: BroadcastOptions): Promise<any[]>;
    serverSideEmit(packet: any[]): void;
    private serverSideEmitWithAck;
}
