export class Document {
    /**
     * @readonly
     */
    static readonly type: "document";
    /**
     * @param {Node[]} [nodes]
     */
    constructor(nodes?: Node[] | undefined);
    /**
     * @readonly
     */
    readonly type: "document";
    /**
     * @type {Node[]}
     */
    nodes: Node[];
    /**
     * Trailing whitespace
     *
     * @type {string=}
     */
    trailing: string | undefined;
    /**
     * Create an identical copy of this document
     *
     * @returns {Document}
     */
    clone(): Document;
    /**
     * Add the given node at the end of this document
     *
     * @param {Node | Document} node
     */
    appendNode(node: Node | Document): void;
    /**
     * Insert the given node to the document before the referenceNode, or at the end if no reference is passed
     *
     * @param {Node | Document} newNode
     * @param {Node | null} referenceNode
     * @throws {Error} If the given referenceNode is not part of this document
     */
    insertNodeBefore(newNode: Node | Document, referenceNode: Node | null): void;
    /**
     * Insert the given node to the document after the referenceNode, or at the beginning if no reference is passed
     *
     * @param {Node | Document} newNode
     * @param {Node | null} referenceNode
     * @throws {Error} If the given referenceNode is not part of this document
     */
    insertNodeAfter(newNode: Node | Document, referenceNode: Node | null): void;
    /**
     * Remove the given node from this document
     *
     * @param {Node} node
     * @throws {Error} if the given node is not in this document
     */
    removeNode(node: Node): void;
    /**
     * Replace the old node with the new node in this document
     *
     * @param {Node} oldNode
     * @param {Node | Document} newNode
     * @throws {Error} if the oldNode is not in this document
     */
    replaceNode(oldNode: Node, newNode: Node | Document): void;
    /**
     * Return all nodes with the given node name
     *
     * Changes to the returned array are not reflected back onto this document
     * itself, and updates to the document won't reflect in the returned array.
     *
     * @param {string} name
     * @returns {Node[]}
     */
    findNodesByName(name: string): Node[];
    /**
     * Return the last node in this document with the given name
     *
     * This function returns the last node instead of first to be in line with
     * how properties are defined in the KDL specification where the last
     * property with the given name is used and the rest is shadowed.
     *
     * @param {string} name
     * @returns {Node | undefined}
     */
    findNodeByName(name: string): Node | undefined;
    /**
     * Return the last node in this document with the given name, matching the parameter
     *
     * If the parameter is `undefined`, this method looks for a node with any single
     * arguments. If a parameter is passed, this method looks for a node with
     * a single parameter, equal to the given parameter.
     *
     * @param {string} name
     * @param {Value['value']} [parameter]
     * @returns {Node | undefined}
     */
    findParameterizedNode(name: string, parameter?: string | number | boolean | null | undefined): Node | undefined;
    /**
     * Remove all nodes with the given name from this document
     *
     * @param {string} name
     * @returns {void}
     */
    removeNodesByName(name: string): void;
    /**
     * Return whether the document is empty
     *
     * @returns {boolean}
     */
    isEmpty(): boolean;
}
import { Node } from "./node.js";
