export class Identifier {
    /**
     * @readonly
     */
    static readonly type: "identifier";
    /**
     * @param {string} name
     */
    constructor(name: string);
    /**
     * @readonly
     */
    readonly type: "identifier";
    /**
     * @type {string=}
     */
    representation: string | undefined;
    /**
     * The identifier itself
     *
     * @type {string}
     * @readonly
     */
    readonly name: string;
    /**
     * Create an identical copy of this identifier
     *
     * @returns {Identifier}
     */
    clone(): Identifier;
}
