"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var asn1js = _interopRequireWildcard(require("asn1js"));

var _pvutils = require("pvutils");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

//**************************************************************************************

/**
 * Class from RFC5280
 */
class AlgorithmIdentifier {
  //**********************************************************************************

  /**
   * Constructor for AlgorithmIdentifier class
   * @param {Object} [parameters={}]
   * @param {Object} [parameters.schema] asn1js parsed value to initialize the class from
   * @property {string} [algorithmId] ObjectIdentifier for algorithm (string representation)
   */
  constructor(parameters = {}) {
    //region Internal properties of the object

    /**
     * @type {string}
     * @desc ObjectIdentifier for algorithm (string representation)
     */
    this.algorithmId = (0, _pvutils.getParametersValue)(parameters, "algorithmId", AlgorithmIdentifier.defaultValues("algorithmId"));
    if ("algorithmParams" in parameters)
      /**
       * @type {Object}
       * @desc Any algorithm parameters
       */
      this.algorithmParams = (0, _pvutils.getParametersValue)(parameters, "algorithmParams", AlgorithmIdentifier.defaultValues("algorithmParams")); //endregion
    //region If input argument array contains "schema" for this object

    if ("schema" in parameters) this.fromSchema(parameters.schema); //endregion
  } //**********************************************************************************

  /**
   * Return default values for all class members
   * @param {string} memberName String name for a class member
   */


  static defaultValues(memberName) {
    switch (memberName) {
      case "algorithmId":
        return "";

      case "algorithmParams":
        return new asn1js.Any();

      default:
        throw new Error(`Invalid member name for AlgorithmIdentifier class: ${memberName}`);
    }
  } //**********************************************************************************

  /**
   * Compare values with default values for all class members
   * @param {string} memberName String name for a class member
   * @param {*} memberValue Value to compare with default value
   */


  static compareWithDefault(memberName, memberValue) {
    switch (memberName) {
      case "algorithmId":
        return memberValue === "";

      case "algorithmParams":
        return memberValue instanceof asn1js.Any;

      default:
        throw new Error(`Invalid member name for AlgorithmIdentifier class: ${memberName}`);
    }
  } //**********************************************************************************

  /**
   * Return value of pre-defined ASN.1 schema for current class
   *
   * ASN.1 schema:
   * ```asn1
   * AlgorithmIdentifier  ::=  Sequence  {
   *    algorithm               OBJECT IDENTIFIER,
   *    parameters              ANY DEFINED BY algorithm OPTIONAL  }
   * ```
   *
   * @param {Object} parameters Input parameters for the schema
   * @returns {Object} asn1js schema object
   */


  static schema(parameters = {}) {
    /**
     * @type {Object}
     * @property {string} algorithmIdentifier ObjectIdentifier for the algorithm
     * @property {string} algorithmParams Any algorithm parameters
     */
    const names = (0, _pvutils.getParametersValue)(parameters, "names", {});
    return new asn1js.Sequence({
      name: names.blockName || "",
      optional: names.optional || false,
      value: [new asn1js.ObjectIdentifier({
        name: names.algorithmIdentifier || ""
      }), new asn1js.Any({
        name: names.algorithmParams || "",
        optional: true
      })]
    });
  } //**********************************************************************************

  /**
   * Convert parsed asn1js object into current class
   * @param {!Object} schema
   */


  fromSchema(schema) {
    //region Clear input data first
    (0, _pvutils.clearProps)(schema, ["algorithm", "params"]); //endregion
    //region Check the schema is valid

    const asn1 = asn1js.compareSchema(schema, schema, AlgorithmIdentifier.schema({
      names: {
        algorithmIdentifier: "algorithm",
        algorithmParams: "params"
      }
    }));
    if (asn1.verified === false) throw new Error("Object's schema was not verified against input data for AlgorithmIdentifier"); //endregion
    //region Get internal properties from parsed schema

    this.algorithmId = asn1.result.algorithm.valueBlock.toString();
    if ("params" in asn1.result) this.algorithmParams = asn1.result.params; //endregion
  } //**********************************************************************************

  /**
   * Convert current object to asn1js object and set correct values
   * @returns {Object} asn1js object
   */


  toSchema() {
    //region Create array for output sequence
    const outputArray = [];
    outputArray.push(new asn1js.ObjectIdentifier({
      value: this.algorithmId
    }));
    if ("algorithmParams" in this && this.algorithmParams instanceof asn1js.Any === false) outputArray.push(this.algorithmParams); //endregion
    //region Construct and return new ASN.1 schema for this object

    return new asn1js.Sequence({
      value: outputArray
    }); //endregion
  } //**********************************************************************************

  /**
   * Convertion for the class to JSON object
   * @returns {Object}
   */


  toJSON() {
    const object = {
      algorithmId: this.algorithmId
    };
    if ("algorithmParams" in this && this.algorithmParams instanceof asn1js.Any === false) object.algorithmParams = this.algorithmParams.toJSON();
    return object;
  } //**********************************************************************************

  /**
   * Check that two "AlgorithmIdentifiers" are equal
   * @param {AlgorithmIdentifier} algorithmIdentifier
   * @returns {boolean}
   */


  isEqual(algorithmIdentifier) {
    //region Check input type
    if (algorithmIdentifier instanceof AlgorithmIdentifier === false) return false; //endregion
    //region Check "algorithm_id"

    if (this.algorithmId !== algorithmIdentifier.algorithmId) return false; //endregion
    //region Check "algorithm_params"

    if ("algorithmParams" in this) {
      if ("algorithmParams" in algorithmIdentifier) return JSON.stringify(this.algorithmParams) === JSON.stringify(algorithmIdentifier.algorithmParams);
      return false;
    }

    if ("algorithmParams" in algorithmIdentifier) return false; //endregion

    return true;
  } //**********************************************************************************


} //**************************************************************************************


exports.default = AlgorithmIdentifier;