"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "exporter", {
    enumerable: true,
    get: function() {
        return exporter;
    }
});
const _fs = require("fs");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _excelUtils = require("../../utils/excelUtils");
const _createModelExporter = require("./modelExporters/createModelExporter");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
async function buildSheetDataForDataType(context, dataType, options) {
    const modelExporter = (0, _createModelExporter.createModelExporter)(context, dataType);
    const tabName = modelExporter.getTabName();
    const data = await modelExporter.getData(options);
    if (!data || data.length === 0) {
        return {
            tabName,
            data: []
        };
    }
    const headers = modelExporter.getHeaders(data);
    return {
        tabName,
        data: [
            headers,
            ...data.map((row)=>headers.map((header)=>{
                    const value = row[header];
                    return modelExporter.formattedCell(header, value);
                }))
        ]
    };
}
async function validateFileSize(fileName, maxSizeInMb) {
    if (!fileName) {
        return;
    }
    const ONE_MEGABYTE_IN_BYTES = 1024 * 1024;
    const { size: fileSizeInBytes } = await _fs.promises.stat(fileName);
    const maxSizeInBytes = maxSizeInMb * ONE_MEGABYTE_IN_BYTES;
    if (fileSizeInBytes > maxSizeInBytes) {
        throw new Error(`File exported exceeds configured maximum of ${maxSizeInMb}mb. Please try again with less data types.`);
    }
}
async function exporter(context, includedDataTypes = {}, options = {}, fileName = '') {
    const sheets = await Promise.all(Object.values(includedDataTypes).map(async (dataType)=>{
        const { data, tabName } = await buildSheetDataForDataType(context, dataType, options);
        return {
            name: tabName,
            data
        };
    }));
    const exportedFileName = (0, _excelUtils.writeExcelFile)(sheets, fileName);
    // This is a temporary fix for limiting the exported file size.
    // TODO: Remove this validation as soon as we implement the download in chunks.
    const { maxFileSizeInMB } = _config.default.export;
    await validateFileSize(exportedFileName, maxFileSizeInMB);
    return exportedFileName;
}

//# sourceMappingURL=exporter.js.map