"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    rangeArraySchema: function() {
        return rangeArraySchema;
    },
    rangeObjectSchema: function() {
        return rangeObjectSchema;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _dateTime = require("@tamanu/utils/dateTime");
const _numbers = require("../../utils/numbers");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const rangeObjectSchema = _yup.object().shape({
    min: _yup.number(),
    max: _yup.number(),
    ageUnit: _yup.string().oneOf([
        'years',
        'months',
        'weeks'
    ]),
    ageMin: _yup.number(),
    ageMax: _yup.number()
}).noUnknown().test({
    name: 'is-min-and-max-valid',
    message: (ctx)=>`${ctx.path} should have either min or max, got ${JSON.stringify(ctx.value)}`,
    test: (value)=>{
        if (!value) {
            return true;
        }
        return (0, _numbers.isNumberOrFloat)(value.min) || (0, _numbers.isNumberOrFloat)(value.max);
    }
}).test({
    name: 'is-age-range-valid',
    message: (ctx)=>`${ctx.path} should have a valid age range.`,
    test: (value)=>{
        if (!value) {
            return true;
        }
        const { ageMin, ageMax } = value;
        // Given we need to support the old format, these could be undefined
        if (ageMin === undefined && ageMax === undefined) {
            return true;
        }
        const atLeastOne = (0, _numbers.isNumberOrFloat)(ageMin) || (0, _numbers.isNumberOrFloat)(ageMax);
        // Ensure both are not zero (comparison below won't work for that scenario)
        const notEqual = ageMin !== ageMax;
        // Min inclusive - max exclusive: cannot be the same
        const minLessThanMax = (ageMin || -Infinity) < (ageMax || Infinity);
        return atLeastOne && notEqual && minLessThanMax;
    }
});
const rangeArraySchema = _yup.array().of(rangeObjectSchema).test({
    name: 'is-range-by-age-valid',
    message: 'Age ranges overlap or have gaps',
    test: (value)=>{
        const areOverlapping = (0, _dateTime.doAgeRangesOverlap)(value);
        const haveGaps = (0, _dateTime.doAgeRangesHaveGaps)(value);
        return areOverlapping === false && haveGaps === false;
    }
});

//# sourceMappingURL=rangeObject.js.map