"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    generateTranslationsForData: function() {
        return generateTranslationsForData;
    },
    normaliseOptions: function() {
        return normaliseOptions;
    }
});
const _lodash = require("lodash");
const _constants = require("@tamanu/constants");
const _translation = require("@tamanu/shared/utils/translation");
const _importerEndpoint = require("./importerEndpoint");
function extractTranslatableRecordText(values, dataType) {
    if (dataType === 'scheduledVaccine') return values.label;
    if (dataType === 'surveyScreenComponent') return {
        text: values.text,
        detail: values.detail
    };
    return values.name;
}
function extractTranslatableOptions(values, dataType) {
    if (dataType === 'programDataElement') {
        return normaliseOptions(values.defaultOptions);
    }
    return normaliseOptions(values.options);
}
function normaliseOptions(options) {
    if (!options) return [];
    let parsedOptions;
    try {
        parsedOptions = JSON.parse(options);
    } catch (e) {
        parsedOptions = options;
    }
    if ((0, _lodash.isArray)(parsedOptions)) return parsedOptions;
    if ((0, _lodash.isObject)(parsedOptions)) return Object.values(parsedOptions);
    if ((0, _lodash.isString)(parsedOptions)) return parsedOptions.split(/\s*,\s*/).filter((x)=>x);
    throw new Error('Invalid options format for translations');
}
function generateTranslationsForData(model, sheetName, values) {
    const translationData = [];
    const dataType = (0, _importerEndpoint.normaliseSheetName)(sheetName, model);
    const isValidTable = model === 'ReferenceData' || (0, _lodash.camelCase)(model) === dataType;
    const isTranslatable = _constants.TRANSLATABLE_REFERENCE_TYPES.includes(dataType);
    if (isTranslatable && isValidTable) {
        const recordText = extractTranslatableRecordText(values, dataType);
        if (recordText && (0, _lodash.isString)(recordText)) {
            const stringId = `${_constants.REFERENCE_DATA_TRANSLATION_PREFIX}.${dataType}.${values.id}`;
            translationData.push({
                stringId,
                text: recordText,
                language: _constants.DEFAULT_LANGUAGE_CODE
            });
        }
        // Handle records with multiple translatable text fields by adding another layer of nesting
        if ((0, _lodash.isObject)(recordText)) {
            Object.entries(recordText).forEach(([key, text])=>{
                const stringId = `${_constants.REFERENCE_DATA_TRANSLATION_PREFIX}.${dataType}.${key}.${values.id}`;
                if (text) {
                    translationData.push({
                        stringId,
                        text,
                        language: _constants.DEFAULT_LANGUAGE_CODE
                    });
                }
            });
        }
        const options = extractTranslatableOptions(values, dataType);
        // // Create translations for reference data record options if they exist
        // // This includes patient_field_definition options
        if (options.length > 0) {
            for (const option of options){
                translationData.push({
                    stringId: (0, _translation.getReferenceDataOptionStringId)(values.id, dataType, option),
                    text: option,
                    language: _constants.DEFAULT_LANGUAGE_CODE
                });
            }
        }
    }
    return translationData;
}

//# sourceMappingURL=translationHandler.js.map