"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "validateVisualisationConfig", {
    enumerable: true,
    get: function() {
        return validateVisualisationConfig;
    }
});
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _safeJsonParse = require("@tamanu/utils/safeJsonParse");
const _numbers = require("../../utils/numbers");
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const checkIfWithinGraphRange = (normalRange, graphRange)=>{
    if ((0, _numbers.isNumberOrFloat)(normalRange.min) && normalRange.min < graphRange.min) {
        return false;
    }
    if ((0, _numbers.isNumberOrFloat)(normalRange.max) && normalRange.max > graphRange.max) {
        return false;
    }
    return true;
};
const validateNormalRangeAsObject = (normalRange, graphRange)=>{
    if (!checkIfWithinGraphRange(normalRange, graphRange)) {
        throw new Error(`normalRange must be within graphRange, got normalRange: ${JSON.stringify(normalRange)}, graphRange: ${JSON.stringify(graphRange)}}`);
    }
    return true;
};
const validateNormalRangeAsArray = (normalRange, graphRange)=>{
    for (const normalRangeObject of normalRange){
        validateNormalRangeAsObject(normalRangeObject, graphRange);
    }
    return true;
};
const validateNormalRange = (normalRange, graphRange)=>{
    if (_yup.object().isType(normalRange)) {
        return validateNormalRangeAsObject(normalRange, graphRange);
    }
    if (_yup.array().isType(normalRange)) {
        return validateNormalRangeAsArray(normalRange, graphRange);
    }
    return false;
};
function validateVisualisationConfig(visualisationConfigString, validationCriteriaString) {
    const visualisationConfig = (0, _safeJsonParse.safeJsonParse)(visualisationConfigString);
    const validationCriteria = (0, _safeJsonParse.safeJsonParse)(validationCriteriaString);
    if (visualisationConfig) {
        if (!validationCriteria) {
            throw new Error('validationCriteria must be specified if visualisationConfig is presented');
        }
        if (!validationCriteria.normalRange) {
            throw new Error('validationCriteria must have normalRange');
        }
        validateNormalRange(validationCriteria.normalRange, visualisationConfig.yAxis.graphRange);
    }
}

//# sourceMappingURL=visualisationConfigValidation.js.map