"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "setFacility", {
    enumerable: true,
    get: function() {
        return setFacility;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _zod = /*#__PURE__*/ _interop_require_wildcard(require("zod"));
const _errors = require("@tamanu/errors");
const _settings = require("@tamanu/settings");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const setFacility = (0, _expressasynchandler.default)(async (req, res)=>{
    const { store: { models }, body, user } = req;
    const { facilityId } = await _zod.object({
        facilityId: _zod.string()
    }).parseAsync(body);
    const userInstance = await models.User.findByPk(user.id);
    const hasAccess = await userInstance.canAccessFacility(facilityId);
    if (!hasAccess) {
        throw new _errors.AuthPermissionError('User does not have access to this facility');
    }
    const facilitySettings = new _settings.ReadSettings(models, facilityId);
    const settings = await facilitySettings.getFrontEndSettings();
    res.send({
        settings
    });
});

//# sourceMappingURL=setFacility.js.map