"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    convertFromDbRecord: function() {
        return convertFromDbRecord;
    },
    convertToDbRecord: function() {
        return convertToDbRecord;
    }
});
const mapRelations = (data, f)=>{
    const relations = {};
    Object.entries(data).forEach(([key, value])=>{
        if (Array.isArray(value)) {
            relations[key] = value.map(f);
        }
    });
    return {
        ...data,
        ...relations
    };
};
const convertToDbRecord = (syncRecord)=>{
    const { data, ...metadata } = syncRecord;
    return {
        ...metadata,
        ...mapRelations(data, convertToDbRecord)
    };
};
const convertFromDbRecord = (dbRecord)=>{
    const { id, deletedAt, ...data } = dbRecord;
    delete data.updatedAt;
    delete data.createdAt;
    delete data.updatedAtSyncTick;
    delete data.password;
    return {
        ...deletedAt ? {
            isDeleted: true
        } : {},
        data: {
            id,
            ...deletedAt ? {} : mapRelations(data, convertFromDbRecord)
        }
    };
};

//# sourceMappingURL=convertDbRecord.js.map