"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "fhirRoutes", {
    enumerable: true,
    get: function() {
        return fhirRoutes;
    }
});
const _express = require("express");
const _errors = require("@tamanu/errors");
const _routeHandlers = require("./routeHandlers");
const _materialised = require("./materialised");
const _requireClientHeaders = require("../middleware/requireClientHeaders");
function fhirRoutes(ctx, { requireClientHeaders } = {}) {
    const routes = (0, _express.Router)();
    if (requireClientHeaders) {
        routes.use(_requireClientHeaders.requireClientHeaders);
    }
    // temporary: will replace this entire route once done
    routes.use('/mat', (0, _materialised.fhirRoutes)(ctx));
    routes.get('/Patient', (0, _routeHandlers.patientHandler)());
    routes.get('/DiagnosticReport', (0, _routeHandlers.diagnosticReportHandler)());
    routes.get('/Immunization', (0, _routeHandlers.immunizationHandler)());
    routes.get('/Patient/:id', (0, _routeHandlers.singlePatientHandler)());
    routes.get('/DiagnosticReport/:id', (0, _routeHandlers.singleDiagnosticReportHandler)());
    routes.get('/Immunization/:id', (0, _routeHandlers.singleImmunizationHandler)());
    routes.use((error, req, res, next)=>{
        // "mat" fhir routes are handled by matRoutes' error handler
        if (res.headersSent) {
            return next(error);
        }
        // legacy "fhir" routes expect this error form
        const problem = _errors.Problem.fromError(error);
        res.status(problem?.status ?? 500).json({
            error: {
                message: problem.detail,
                ...error
            }
        });
    });
    return routes;
}

//# sourceMappingURL=index.js.map