"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getAllergyIntolerances", {
    enumerable: true,
    get: function() {
        return getAllergyIntolerances;
    }
});
const _uuid = require("uuid");
const _constants = require("@tamanu/constants");
const _utils = require("../utils");
const getAllergyIntolerances = async ({ patient, models, dataDictionariesIps })=>{
    const patientAllergies = await models.PatientAllergy.findAll({
        where: {
            patientId: patient.id
        },
        include: [
            'allergy'
        ]
    });
    const allergyIntolerancesHeader = {
        resourceType: _constants.FHIR_RESOURCE_TYPES.ALLERGY_INTOLERANCE,
        patient: (0, _utils.getEntryResourceSubject)(patient),
        clinicalStatus: {
            coding: [
                {
                    system: 'http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical',
                    code: 'active'
                }
            ]
        }
    };
    if (!patientAllergies?.length) {
        const allergyCodingDisplay = 'No known allergies';
        return [
            {
                id: (0, _uuid.v4)(),
                ...allergyIntolerancesHeader,
                code: {
                    coding: [
                        {
                            system: dataDictionariesIps.absentUnknown,
                            code: 'no-known-allergies',
                            display: allergyCodingDisplay
                        }
                    ]
                },
                text: {
                    status: 'generated',
                    div: `<div xmlns="http://www.w3.org/1999/xhtml">These are the Allergy Intolerance details for ${patient.displayName} for ${allergyCodingDisplay}. Please review the data for more detail.</div>`
                }
            }
        ];
    }
    return patientAllergies.map((patientAllergy)=>({
            id: (0, _uuid.v4)(),
            ...allergyIntolerancesHeader,
            code: {
                coding: [
                    {
                        system: dataDictionariesIps.allergyIntoleranceEncoding,
                        code: patientAllergy.allergy.code,
                        display: patientAllergy.allergy.name
                    }
                ]
            },
            text: {
                status: 'generated',
                div: `<div xmlns="http://www.w3.org/1999/xhtml">These are the Allergy Intolerance details for ${patient.displayName} for ${patientAllergy.allergy.name}. Please review the data for more detail.</div>`
            }
        }));
};

//# sourceMappingURL=allergyIntolerance.js.map