"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "buildSearchQuery", {
    enumerable: true,
    get: function() {
        return buildSearchQuery;
    }
});
const _lodash = require("lodash");
const _parameters = require("@tamanu/shared/utils/fhir/parameters");
const _common = require("./common");
const _where = require("./where");
const _order = require("./order");
function buildSearchQuery(query, parameters, FhirResource) {
    const sql = {
        limit: _parameters.FHIR_COUNT_CONFIG_DEFAULT
    };
    if (query.has('_sort')) {
        sql.order = (0, _order.generateOrderClause)(query, parameters, FhirResource);
    }
    if (query.has('_count')) {
        const count = (0, _lodash.last)(query.get('_count').flatMap((v)=>v.value));
        if (count === 0) {
            (0, _common.pushToQuery)(query, '_summary', {
                value: [
                    'count'
                ]
            });
        } else {
            sql.limit = count;
        }
    }
    if (query.has('_page')) {
        const page = (0, _lodash.last)(query.get('_page').flatMap((v)=>v.value));
        sql.offset = page * sql.limit;
    }
    // TODO: support _summary and _elements
    sql.where = (0, _where.generateWhereClause)(query, parameters, FhirResource);
    return sql;
}

//# sourceMappingURL=query.js.map