"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "searchHandler", {
    enumerable: true,
    get: function() {
        return searchHandler;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _yup = require("yup");
const _constants = require("@tamanu/constants");
const _fhir = require("@tamanu/shared/utils/fhir");
const _bundle = require("../bundle");
const _common = require("./common");
const _include = require("./include");
const _query = require("./query");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function searchHandler(FhirResource) {
    return (0, _expressasynchandler.default)(async (req, res)=>{
        const parameters = (0, _fhir.normaliseParameters)(FhirResource);
        const query = await parseRequest(req, parameters);
        let includes = null;
        if (query.has('_include')) {
            includes = (0, _include.resolveIncludes)(req.store.models, query, parameters, FhirResource);
        }
        const sqlQuery = (0, _query.buildSearchQuery)(query, parameters, FhirResource);
        const total = await FhirResource.count(sqlQuery);
        const records = await FhirResource.findAll(sqlQuery);
        const { included, errors } = await (0, _include.retrieveIncludes)(req.store.models, records, includes, FhirResource);
        const bundle = new _bundle.Bundle(_constants.FHIR_BUNDLE_TYPES.SEARCHSET, records, {
            total
        });
        bundle.addSelfUrl(req);
        bundle.addIncluded(included);
        bundle.addIssues(errors);
        res.send(bundle.asFhir());
    });
}
async function parseRequest(req, parameters) {
    const pairs = Object.entries(req.query).flatMap(([name, values])=>Array.isArray(values) ? values.map((v)=>[
                name,
                v
            ]) : [
            [
                name,
                values
            ]
        ]);
    const errors = [];
    const query = new Map();
    for (const [name, value] of pairs){
        const [param, modifier] = name.split(':', 2);
        if (!parameters.has(param)) {
            // TODO: support Prefer: handling=lenient
            errors.push(new _fhir.Unsupported(`parameter is not supported: ${param}`));
            continue;
        }
        const values = [];
        for (const part of value.split(',')){
            try {
                values.push(await parameters.get(param).parameterSchema.validate(part));
            } catch (err) {
                if (err instanceof _yup.ValidationError) {
                    errors.push(_fhir.OperationOutcome.fromYupError(err, param));
                } else {
                    errors.push(new _fhir.Invalid(err.message, {
                        expression: param
                    }));
                }
            }
        }
        (0, _common.pushToQuery)(query, param, {
            modifier,
            value: values
        });
    }
    if (errors.length > 0) {
        throw new _fhir.OperationOutcome(errors);
    }
    return query;
}

//# sourceMappingURL=search.js.map