"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "routes", {
    enumerable: true,
    get: function() {
        return routes;
    }
});
const _express = /*#__PURE__*/ _interop_require_default(require("express"));
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _datefns = require("date-fns");
const _logging = require("@tamanu/shared/services/logging");
const _errors = require("@tamanu/errors");
const _Crypto = require("./Crypto");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const routes = _express.default.Router();
// req.checkPermission isn't implemented on central-server yet
// TODO: Swap this out when it is
function checkAdmin(user) {
    if (user?.role !== 'admin') {
        throw new _errors.ForbiddenError('Insufficient permissions');
    }
}
routes.get('/exportCertificateRequest', (0, _expressasynchandler.default)(async (req, res)=>{
    // req.checkPermission('read', 'Signer');
    checkAdmin(req.user);
    _logging.log.info('Exporting certificate request');
    const { Signer } = req.store.models;
    const pending = await Signer.findPending();
    if (pending) {
        res.status(200).send({
            request: pending.request
        });
    } else {
        throw new _errors.NotFoundError('Pending signer not found');
    }
}));
routes.post('/importCertificate', (0, _expressasynchandler.default)(async (req, res)=>{
    // req.checkPermission('write', 'Signer');
    checkAdmin(req.user);
    const { Signer } = req.store.models;
    const { body } = req;
    const signerData = await (0, _Crypto.loadCertificateIntoSigner)(body.certificate, body.workingPeriod);
    const pending = await Signer.findPending();
    if (!pending) {
        throw new _errors.NotFoundError('Pending signer not found');
    }
    await pending.update(signerData);
    const start = (0, _datefns.format)(signerData.workingPeriodStart, 'yyyy-MM-dd');
    const end = (0, _datefns.format)(signerData.workingPeriodEnd, 'yyyy-MM-dd');
    _logging.log.info(`Loaded ICAO Signer (${start} - ${end})`);
    res.status(200).send({
        message: `Loaded ICAO Signer (${start} - ${end})`
    });
}));

//# sourceMappingURL=routes.js.map