"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getLocalisation", {
    enumerable: true,
    get: function() {
        return getLocalisation;
    }
});
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _yup = /*#__PURE__*/ _interop_require_wildcard(require("yup"));
const _lodash = require("lodash");
const _logging = require("@tamanu/shared/services/logging");
const _constants = require("@tamanu/constants");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
function _getRequireWildcardCache(nodeInterop) {
    if (typeof WeakMap !== "function") return null;
    var cacheBabelInterop = new WeakMap();
    var cacheNodeInterop = new WeakMap();
    return (_getRequireWildcardCache = function(nodeInterop) {
        return nodeInterop ? cacheNodeInterop : cacheBabelInterop;
    })(nodeInterop);
}
function _interop_require_wildcard(obj, nodeInterop) {
    if (!nodeInterop && obj && obj.__esModule) {
        return obj;
    }
    if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
            default: obj
        };
    }
    var cache = _getRequireWildcardCache(nodeInterop);
    if (cache && cache.has(obj)) {
        return cache.get(obj);
    }
    var newObj = {
        __proto__: null
    };
    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
    for(var key in obj){
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
            if (desc && (desc.get || desc.set)) {
                Object.defineProperty(newObj, key, desc);
            } else {
                newObj[key] = obj[key];
            }
        }
    }
    newObj.default = obj;
    if (cache) {
        cache.set(obj, newObj);
    }
    return newObj;
}
const imagingTypeSchema = _yup.object({
    label: _yup.string().required()
}).noUnknown();
const imagingTypesSchema = _yup.object({
    ...Object.values(_constants.IMAGING_TYPES).reduce((fields, field)=>({
            ...fields,
            [field]: imagingTypeSchema
        }), {})
}).required();
const rootLocalisationSchema = _yup.object({
    units: _yup.object({
        temperature: _yup.string().oneOf([
            'celsius',
            'fahrenheit'
        ])
    }),
    country: {
        name: _yup.string().min(1).required(),
        'alpha-2': _yup.string().uppercase().length(2).required(),
        'alpha-3': _yup.string().uppercase().length(3).required()
    },
    timeZone: _yup.string().nullable(),
    imagingTypes: imagingTypesSchema,
    previewUvciFormat: _yup.string().required().oneOf([
        'tamanu',
        'eudcc',
        'icao'
    ]),
    disabledReports: _yup.array(_yup.string().required()).defined(),
    supportDeskUrl: _yup.string().required()
}).required().noUnknown();
// TODO: once localisation is persisted in the db, dynamically reload this
const unvalidatedLocalisation = (0, _lodash.defaultsDeep)(_config.default.localisation.data);
const localisationPromise = rootLocalisationSchema.validate(unvalidatedLocalisation, {
    strict: true,
    abortEarly: false
}).then((l)=>{
    _logging.log.info('Localisation validated successfully.');
    return l;
}).catch((e)=>{
    const errors = e.inner.map((inner)=>`\n  - ${inner.message}`);
    _logging.log.error(`Error(s) validating localisation (check localisation.data in your config):${errors}`);
    if (!_config.default.localisation.allowInvalid) {
        process.exit(1);
    }
});
const getLocalisation = async ()=>{
    if (_config.default.localisation.allowInvalid) {
        return unvalidatedLocalisation;
    }
    const localisation = await localisationPromise;
    return localisation;
};

//# sourceMappingURL=localisation.js.map