"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getOngoingConditions", {
    enumerable: true,
    get: function() {
        return getOngoingConditions;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _sequelize = require("sequelize");
const _ongoingConditionschema = require("@tamanu/shared/schemas/patientPortal/responses/ongoingCondition.schema");
const _schemaUtils = require("../../utils/schemaUtils");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getOngoingConditions = (0, _expressasynchandler.default)(async (req, res)=>{
    const { patient } = req;
    const { models } = req.store;
    const ongoingConditions = await models.PatientCondition.findAll({
        where: {
            patientId: patient.id,
            resolved: {
                [_sequelize.Op.ne]: true
            }
        },
        attributes: (0, _schemaUtils.getAttributesFromSchema)(_ongoingConditionschema.OngoingConditionSchema),
        include: [
            {
                model: models.ReferenceData,
                as: 'condition',
                attributes: (0, _schemaUtils.getAttributesFromSchema)(_ongoingConditionschema.OngoingConditionSchema.shape.condition)
            }
        ]
    });
    res.send(ongoingConditions.map((condition)=>_ongoingConditionschema.OngoingConditionSchema.parse(condition.forResponse())));
});

//# sourceMappingURL=ongoingConditions.js.map