"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getSurvey", {
    enumerable: true,
    get: function() {
        return getSurvey;
    }
});
const _expressasynchandler = /*#__PURE__*/ _interop_require_default(require("express-async-handler"));
const _patientPortal = require("@tamanu/shared/schemas/patientPortal");
const _schemaUtils = require("../../utils/schemaUtils");
const _errors = require("@tamanu/errors");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const getSurvey = (0, _expressasynchandler.default)(async (req, res)=>{
    const { params } = req;
    const { models } = req.store;
    const { surveyId } = params;
    const surveyRecord = await models.Survey.findByPk(surveyId, {
        attributes: (0, _schemaUtils.getAttributesFromSchema)(_patientPortal.SurveySchema),
        include: [
            {
                association: 'portalSurveyAssignments',
                order: [
                    [
                        'created_at',
                        'DESC'
                    ]
                ],
                limit: 1
            }
        ]
    });
    if (!surveyRecord) {
        throw new _errors.NotFoundError('Survey was not found');
    }
    const components = await models.SurveyScreenComponent.getComponentsForSurvey(surveyRecord.id, {
        includeAllVitals: true
    });
    const payload = {
        ...surveyRecord.forResponse(),
        components,
        // There can only ever be one portalSurveyAssignment so attach it directly to the survey response
        portalSurveyAssignment: surveyRecord.portalSurveyAssignments?.[0] || null
    };
    // Remove the array version
    delete payload.portalSurveyAssignments;
    // Parse the payload with zod to validate the data but return the unparsed payload
    // as zod is transforming dataElement.default options to a string unintentionally
    _patientPortal.SurveyWithComponentsSchema.parse(payload);
    return res.send(payload);
});

//# sourceMappingURL=survey.js.map