"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    genToken: function() {
        return genToken;
    },
    issueCommand: function() {
        return issueCommand;
    }
});
const _commander = require("commander");
const _config = /*#__PURE__*/ _interop_require_default(require("config"));
const _auth = require("@tamanu/constants/auth");
const _importable = require("@tamanu/constants/importable");
const _utils = require("../../auth/utils");
const _database = require("../../database");
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
const genToken = async (email, { expiresIn })=>{
    // find user
    const store = await (0, _database.initDatabase)({
        testMode: false
    });
    const user = await store.sequelize.models.User.findOne({
        where: {
            email,
            visibilityStatus: _importable.VISIBILITY_STATUSES.CURRENT
        }
    });
    if (!user) {
        throw new Error('Could not find user with that email');
    }
    // generate token
    const token = await (0, _utils.buildToken)({
        userId: user.id
    }, null, {
        expiresIn,
        audience: _auth.JWT_TOKEN_TYPES.ACCESS,
        issuer: _config.default.canonicalHostName
    });
    // cleanup
    if (process.env.NODE_ENV !== 'test') {
        await (0, _database.closeDatabase)();
    }
    return token;
};
const issue = async (email, options)=>{
    // issue() and genToken() are split up to make testing easier
    const token = await genToken(email, options);
    process.stderr.write(`Expires in ${options.expiresIn} (see -e option, in --help output)\n`);
    process.stdout.write(`${token}\n`);
};
const issueCommand = new _commander.Command('issue').description('Issue a new API key').argument('<email>', 'Email of the user the key should authenticate as').option('-e, --expiresIn <expiresIn>', 'Token expiry (see https://github.com/vercel/ms for format)', '3 months').action(issue);

//# sourceMappingURL=issue.js.map