"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "ChangelogNotePagesToEncounterHistory", {
    enumerable: true,
    get: function() {
        return ChangelogNotePagesToEncounterHistory;
    }
});
const _dataMigrations = require("@tamanu/database/dataMigrations");
const _getChangelogToEncounterHistoryQuery = require("./getChangelogToEncounterHistoryQuery");
const _constants = require("@tamanu/constants");
function _define_property(obj, key, value) {
    if (key in obj) {
        Object.defineProperty(obj, key, {
            value: value,
            enumerable: true,
            configurable: true,
            writable: true
        });
    } else {
        obj[key] = value;
    }
    return obj;
}
const NOTE_PAGE_SUB_QUERY = `
    select
        np.id,
        np.record_id,
        np.note_type_id,
        ni.author_id as actor_id,
        ni.date,
        ni.content
    from note_pages np
    left join note_items ni on ni.note_page_id = np.id
    join batch_encounters e on np.record_id = e.id
    where note_type_id = '${_constants.NOTE_TYPES.SYSTEM}'
    and record_type = 'Encounter'
    order by np.record_id, ni.date
`;
let ChangelogNotePagesToEncounterHistory = class ChangelogNotePagesToEncounterHistory extends _dataMigrations.CursorDataMigration {
    async getQuery() {
        return (0, _getChangelogToEncounterHistoryQuery.getChangelogToEncounterHistoryQuery)(NOTE_PAGE_SUB_QUERY);
    }
    constructor(...args){
        super(...args), _define_property(this, "lastMaxId", '');
    }
};
_define_property(ChangelogNotePagesToEncounterHistory, "defaultBatchSize", Number.MAX_SAFE_INTEGER);
_define_property(ChangelogNotePagesToEncounterHistory, "defaultDelayMs", 50);

//# sourceMappingURL=ChangelogNotePagesToEncounterHistory.js.map